<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller {
	function __construct(){
    parent::__construct();
		  $this->load->database();
		  $this->load->helper('cookie');
		 
    }
public function index()
{
    //redirect('login');
	$page_data['page_name'] = "welcome";
    $page_data['page_title'] = 'Welcome to '.get_settings('app_name');
    $this->load->view('Auth/index', $page_data);
}
public function alertpage()
{
   	$page_data['page_name'] = "alertpage";
    $page_data['page_title'] = 'Alert page';
    $this->load->view('Auth/index', $page_data);
}

public function do_setPIN()
{
    if($this->session->userdata('loginId') == false ){
        $this->session->set_flashdata('error_message', 'Access denied! Please login to continue');
        redirect('login');
        exit;
      }
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
      $user_id = $udetails['accountid'];
    $code1 = $this->escapeString('code1');
    $code2 = $this->escapeString('code2');
    $code3 = $this->escapeString('code3');
    $code4 = $this->escapeString('code4');
    $otpCode = $code1.$code2.$code3.$code4; 
    $data['security_pin'] = $otpCode;
    $this->db->where('accountid',$user_id);
    $this->db->update('account',$data);
    $this->session->set_flashdata('success_msg','Your PIN has been successfully saved');
    redirect('dashboard');
    
}
public function setPIN()
{
	$page_data['page_name'] = "setPIN";
    $page_data['page_title'] = 'Set PIN';
    $this->load->view('Account/index', $page_data);
}

public function fileinfo()
{
    $page_data['page_name'] = "fileinfo";
    $page_data['page_title'] = 'Home Page';
    $this->load->view('Auth/fileinfo', $page_data);
}
public function login()
{
	$page_data['page_name'] = "login";
    $page_data['page_title'] = 'Login Page';
    $this->load->view('Auth/index', $page_data);
}
public function register(){
	
    $page_data['page_name'] = "register";
    $page_data['page_title'] = 'Register Page';
    if((isset($_GET['reff'])) && (!empty($_GET['reff'])))
    {
    $ref = $_GET['reff'];
     $session_data = array('ref' => $ref,'referral' => TRUE);
    $this->session->set_userdata($session_data);    
    // $page_data['referral'] = $_GET['reff'];  
    }
    $this->load->view('Auth/index', $page_data);
}

public function newpassword()
{
      if(($this->session->userdata('reset_password') == false )){
        $this->session->set_flashdata('error_message', 'Access denied! Please login to continue');
        redirect('fpassword');
      }else{
        $page_data['page_name'] = "newpassword";
        $page_data['page_title'] = 'Enter New Password for your account';
        $this->load->view('Auth/index', $page_data);   
      }
}
public function do_reg()
{
    if($this->User_model->get_module('19') == false){
         $this->session->set_flashdata('error_message', 'Registration is temporary disabled. Please check back later');
             redirect('register');  
             exit;
    }
    $email_address = $this->escapeString('email_address'); 
    $verify = $this->Auth_model->loginwithEmail($email_address);;
    if($verify)
  {
     $this->session->set_flashdata('error_message', 'The email you entered already exist on our platform. Please use forget password to login to your existing account'); 
     redirect('register');
     exit;
  }
  $token = $this->uniqueidwithlenght('4');
    $to = $email_address;
      $sub = 'Complete your registration on '.get_settings('app_name');
      $page_data['token'] = $token;
      $page_data['to'] = $to;
      $page_data['subject'] = $sub;
       $message = $this->load->view('Auth/Emails/confirm_email',$page_data,TRUE);
      if($this->send_mail($to,$sub,$message)){
        $session_data = array('to' => $to,'token' => $token, 'verification' => TRUE);
        $this->session->set_userdata($session_data);
         $this->session->set_flashdata('success_msg', 'Please check your email inbox/spambox for your verification code');
         redirect('otp');
      }else{
    $this->session->set_flashdata('error_message', 'Unable to complete this request. Please contact support for further assistance'); 
     redirect('register');
      }
}
public function do_validateCode()
{
    if(($this->session->userdata('verification') == false ))
    {
       $this->session->set_flashdata('error_message', 'code has expired'); 
         redirect('register');
         exit;
    }
    $token = $this->session->userdata('token');
    $to = $this->session->userdata('to');
    $code1 = $this->escapeString('code1');
    $code2 = $this->escapeString('code2');
    $code3 = $this->escapeString('code3');
    $code4 = $this->escapeString('code4');
     $otpCode = $code1.$code2.$code3.$code4;
   if($otpCode == $token)
    {
    $this->session->set_flashdata('success_msg', 'Please fill the form to get fully onboard'); 
    $page_data['email_address'] = $to;
    $page_data['page_name'] = "register_user";
    $page_data['page_title'] = 'Register Page';
    //$this->session->unset_userdata('verification');
    //$this->session->unset_userdata('token');
    //$this->session->unset_userdata('to');
    $this->load->view('Auth/index', $page_data);
    }else{
        $this->session->set_flashdata('error_message', 'Invalid code supplied'); 
         redirect('otp');
         exit;
    }
}
public function otp()
{
  $page_data['page_name'] = "otp";
  $page_data['page_title'] = 'OTP verification';
  $this->load->view('Auth/index', $page_data);
}
 public function uniqueidwithlenght($lenght)
  {
    $un = substr(number_format(time() * rand(),0,'',''),0,$lenght);
    return $un;
  }
public function do_password_reset()
{
    if(($this->session->userdata('reset_password') == false )){
        $this->session->set_flashdata('error_message', 'Access denied! Please login to continue');
        redirect('fpassword');
      }else{
         $new_password = $this->input->post('newpassword'); 
         $confirmpassword = $this->input->post('confirmpassword');
         if($new_password != $confirmpassword)
            {
                $this->session->set_flashdata('error_message', 'Password mismatch. Your password and confirm password do not match');
                     redirect('fpassword');  
                     exit;
            }
         $token = $this->session->userdata('token');
         $result = $this->Auth_model->token_login($token);
         $new_password_hash = password_hash($new_password, PASSWORD_BCRYPT);
        $update = $this->Auth_model->update_new_password($token,$new_password_hash,$result['email']);  
        if($update){
        $this->session->unset_userdata('reset_password');
         $this->session->set_flashdata('success_msg', 'Your account password has been updated successfully. You may now login with your new password');
        redirect('login');   
        }else{
           $this->session->set_flashdata('error_message', 'Error occured while sending your request. Please try again later');
        redirect('fpassword');    
        }
      }
}
public function fpassword(){
	
  $page_data['page_name'] = "fpassword";
  $page_data['page_title'] = 'Reset Password';
  $this->load->view('Auth/index', $page_data);
}
public function do_fpassword(){
  $phone = $this->input->post('phonenumber');
  $verify = $this->Auth_model->checkEmailorPhone($phone);
  $token = $this->uniqueid();
  $hash_token = md5($token);
  if($verify)
  {
    $this->Auth_model->update_user_token($verify['phone'],$hash_token);
    $result = $this->Auth_model->checkEmailorPhone($phone);
    $to = $result['email'];
      $sub = 'Password Reset Instruction';
      $page_data['user_data'] = $result;
       $page_data['details'] = $result;
       $message = $this->load->view('Auth/Emails/password_reset_email',$page_data,TRUE);
       $this->send_mail($to,$sub,$message);
  $this->session->set_flashdata('success_msg', 'Thank you for providing your account details. Further instruction has been sent to your registered email address');
  redirect('fpassword');   
  }else{
    $this->session->set_flashdata('error_message', 'The details you supplied does not match any of our records');
  redirect('fpassword');  
  }
  
} 
public function confirm_password_reset()
{
    if(isset($_GET['token'])&& (!empty($_GET['token'])))
    {
     $token = $_GET['token'];
     $result = $this->Auth_model->token_login($token);
     if($result)
    {
         $password_session_data = array(
                    'email' => $result['email'],
                    'token' => $token,
                    'session_id' => session_id(),
                    'reset_password' => TRUE
                );
        $this->session->set_userdata($password_session_data);
       redirect('newpassword'); 
    }else{
        $this->session->set_flashdata('error_message', 'Ops! We do not recognize this link.');
        redirect('fpassword');   
    }
    }else{
       $this->session->set_flashdata('error_message', 'Ops! We do not recognize this link.');
        redirect('fpassword');   
    }
}

public function escapeString($string) {
    return remove_invisible_characters(html_escape($this->input->post($string)));
  }
  public function uniqueid()
  {
    $un = substr(number_format(time() * rand(),0,'',''),0,6);
    return $un;
  }
public function random_strings($length_of_string)
{
$str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
return substr(str_shuffle($str_result),
                   0, $length_of_string);
}
public function migrateSubscribers()
  {
      $allSubscibers = $this->db->get('transactionsold');
      if($allSubscibers->num_rows() > 0)
      {
          foreach($allSubscibers->result_array() as $each)
          {
              $data['user_id'] = $each['sId'];
              $data['order_id '] = $each['transref'];
              $data['description'] = $each['servicename'].' '.$each['servicedesc'];
              $data['amount'] = $each['amount'];
              $data['charge'] = $each['amount'];
              //if($each['status'] == '0'){
              $data['status'] = '1';
             // }else{
             // $data['status'] = '0';    
             // }
              $data['prev_bal'] = $each['oldbal'];
              $data['new_bal'] = $each['newbal'];
              $data['profit'] = $each['profit'];
              $data['date_added'] = $each['date'];
              $data['api_response'] = $each['api_response'];
              if($each['status'] == '0'){
              $data['trans_status'] = 'successful';
              }else{
                $data['trans_status'] = 'processing';  
              }
              
              $this->db->insert('transactions',$data);
          }
      }
      echo 'all done';
  }
 public function do_register() 
{
    if(($this->session->userdata('verification') == false ))
    {
       $this->session->set_flashdata('error_message', 'code has expired'); 
         redirect('register');
         exit;
    }
    //$token = $this->session->userdata('token');
    $email = $this->escapeString('emailaddress');//$this->session->userdata('to');
    $phonenumber = removeSpaces($this->escapeString('phonenumber'));
    $password = $this->escapeString('password');
   // $security_pin = $this->escapeString('security_pin');
    $confirmpassword = $this->escapeString('confirmpassword');
    $apiKey = substr(str_shuffle("0123456789ABCDEFGHIJklmnopqrstvwxyzAbAcAdAeAfAgAhBaBbBcBdC1C23C3C4C5C6C7C8C9xix2x3"), 0, 60).time();
   /* if(strlen($security_pin) !='4')
    {
        $this->session->set_flashdata('error_message', 'Security PIN must be 4 digit');
             redirect('register');  
             exit;
    }
  */
	if($password != $confirmpassword)
    {
        $this->session->set_flashdata('error_message', 'Password mismatch. Your password and confirm password do not match');
             redirect('register');  
             exit;
    }
    if((checkBlacklist($phonenumber) == true)||(checkBlacklist($email) == true))
        {
           $this->session->set_flashdata('error_message', 'Unable to register this account. Please contact support');
             redirect('register');  
             exit; 
        } 
   $firstname = removeSpaces($this->escapeString('firstname'));
   $lastname = removeSpaces($this->escapeString('lastname'));
    $fullname = $firstname.' '.$lastname;
    $password_lenght = strlen($password);
    $minimumPassword = get_settings('password_lenght');
        if($password_lenght < $minimumPassword)
           {
             $this->session->set_flashdata('error_message', 'Minimum of '.$minimumPassword.' character is required for your password');
             redirect('register');  
             exit;
           }
           if((empty($phonenumber)||empty($email)))
           {
             $this->session->set_flashdata('error_message', 'Email address and Phone Number is required');
              redirect('register');  
           }
    if (isset($_POST['referral'])){$referral = $this->escapeString('referral');}else{$referral = '';}
    if($referral !=''){ 
        $check = $this->Auth_model->validate_refcode($referral);
        if($check != false)
        {
            $sponsor_id = $check['accountid']; 
        }else{
            $this->session->set_flashdata('error_message', 'Invalid Referral Link. No account found with the referral link');
            redirect('register');
            exit;
        }
    }else{
        $sponsor_id = '';
    }
    $userData = array(
        'email' => $email,
        'phone' => $phonenumber,
        'fullname' => $fullname,
        'api_key'=> $apiKey,
         'password' => password_hash($password, PASSWORD_BCRYPT),
         'sponsor_id' => $sponsor_id,
         'referral_code' =>$this->random_strings('4'),
         'signup_bonus' => get_settings('signup_bonus')
        
    );
    $checkPhone = $this->Auth_model->check_exist($email,$phonenumber);
             if(($checkPhone == false)){
                $insert = $this->Auth_model->register_new($userData);
              //  $this->session->unset_userdata('verification');
                //$this->session->unset_userdata('token');
                //$this->session->unset_userdata('to');
                //$this->session->unset_userdata('referral');
                $this->session->set_flashdata('success_alert', 'Thank you for creating account with us. Your account has been created successfully.');
            redirect('login');
             }else{
            $this->session->set_flashdata('error_message', 'Account could not be created. It seems you have account with us. Forget password? please use the forget password link');
            redirect('register');
             }
}
public function check_exist($email,$phone) 
{
    $this->db->where('phone', $phone);
    $this->db->or_where('email', $email);
   $query = $this->db->get('account');
    if ($query->num_rows() == 1) {
        //$user = $query->row_array();
        return true;
    } else {
        return false;
    }
}

 public function create_session($result)
  {
      $this->session_destroy();
      $user_phone = $result['phone'];
      $hasTime = time();
       //delete_cookie("loginPhone");
       $session_id = sha1($hasTime.$user_phone);
        $myTime = date('Y-m-d H:i:s', time());
        $ip_address = $this->input->ip_address(); 
      $this->Auth_model->update_session_id($result['accountid'],$session_id); 
      $session_data = array(
                    'loginId' => $session_id,
                    'session_id' => session_id(),
                    'loginName' => $result['fullname'],
                    'loginPhone' => $result['phone'],
                    'member_session' => TRUE
                );
        $this->session->set_userdata($session_data);
         //$cookie= array('Acctphone'   => $result['phone'],'fullname'  => $result['fullname'],'expire' => (31540000 * 30),'secure' => TRUE);
        //$this->input->set_cookie($cookie);
        $result = $this->Auth_model->insert_login($result['accountid'],$ip_address,$session_id);
        return $session_data;
  }
public function do_login() 
{
    if($this->User_model->get_module('18') == false){
         $this->session->set_flashdata('error_message', 'Login is temporary disabled. Please check back later');
             redirect('login');  
             exit;
    }
        $phonenumber = $this->escapeString('phonenumber');
        $password = $this->escapeString('password');
        if(checkBlacklist($phonenumber) == true)
        {
           $this->session->set_flashdata('error_message', 'Unable to login this account. Please contact support');
             redirect('login');  
             exit; 
        }
       $result = $this->Auth_model->checkEmailorPhone($phonenumber);
       if($result == false)
       {
         $this->session->set_flashdata('error_message',('Invalid Username Or Password'));
           redirect('login');
           exit;
       }
       if($result['suspend'] == 1){
           $this->session->set_flashdata('error_message',('Account Blocked, Please Contact Customer Support For Additional Information')); 
           redirect('login');
           exit;
       }
       if($result['referral_code']  == '')
       {
         $uref['referral_code'] = $this->random_strings('4');
         $this->db->where('accountid',$result['accountid']);
        $this->db->update('account',$uref);
       }
      	$hash=substr(sha1(md5($password)), 3, 10);
       if (password_verify($password, $result['password'])) 
        {
            $this->create_session($result);
            $this->login_notification($result);
            //$this->updatePaga($result);
            $this->session->set_flashdata('success_alert',('Welcome back, '.$result['fullname']));
            redirect('dashboard');
        }elseif($result['password'] == $hash){
            $this->updatePasswordLogin($result,$password);
            $this->create_session($result);
            $this->login_notification($result);
            $this->session->set_flashdata('success_alert',('Welcome back, '.$result['fullname']));
            redirect('dashboard');
        }else{
       $this->session->set_flashdata('error_message',('Invalid Username Or Password'));
       redirect('login');
            }
 }
 /*
 public function deletePage()
 {
     $pick = $this->db->get('account');
     foreach($pick->result_array() as $each)
     {
         if(!empty($each['paga']))
         {
             $data['paga'] = '';
             $this->db->where('accountid',$each['accountid']);
             $this->db->update('account',$data);
         }
     }
     echo 'All done';
 }
 */
 
 public function updatePaga($result)
 {
     if(empty($result['paga']))
     {
       // $pick = $this->db->get_where('users',array('email'=>$result['email']));
        if($pick->num_rows() > 0)
        {
            $row = $pick->row_array();
            $data['paga'] = $row['paga'];
            $this->db->where('email',$result['email']);
            $this->db->update('account',$data);
            return true;
        }else{
            return true;
        }
     }else{
         return true;
     }
 }
 public function updatePasswordLogin($result,$password)
 {
     $data['password'] = password_hash($password, PASSWORD_BCRYPT);
     $this->db->where('accountid',$result['accountid']);
     $this->db->update('account',$data);
     return true;
 }
 public function logout($from = "") {
      //destroy sessions of specific userdata. We've done this for not removing the cart session
      $this->session_destroy();
      $this->session->set_flashdata('success_alert',('Logged out successfully'));
     redirect('login');
     
    }
    public function session_destroy() {
      $this->session->unset_userdata('loginId');
      $this->session->unset_userdata('member_session');
      $this->session->unset_userdata('loginName');
      $this->session->unset_userdata('loginPhone');
      $this->session->unset_userdata('session_id');
     return true;
    }
public function login_notification($result)
{           
            $to = $result['email'];
            $sub = 'New Login Notification on '.get_settings('app_name');
            $page_data['user_data'] = $result;
            $message = $this->load->view('Auth/Emails/login_email',$page_data,TRUE);
            $this->send_mail($to,$sub,$message);
         return true;
       
}
public function send_mailv2($to ='temmydev0@gmail.com', $sub ='Hello customer', $email_body='Hi, this is checking email'){
  $this->load->library('phpmailer_lib');
  $from_name = 'info@topnet.ng';//get_settings('smtp_user');
  $app_name = get_settings('app_name');
  $mail = $this->phpmailer_lib->load();
  $host = 'mail.privateemail.com';//get_settings('smtp_host');
  $port = '465';//get_settings('smtp_port');
  $user = 'contact@doctroidhealthcare.com';//get_settings('smtp_user');
  $pass = 'doctriod@Contact2024!';//get_settings('smtp_pass');
  $mail->isSMTP();
  $mail->Host     = $host;
  $mail->SMTPAuth = true;
  $mail->Username = $user;
  $mail->Password = $pass;
  $mail->SMTPSecure = 'ssl';
  $mail->Port    = $port;
  $mail->setFrom($user, $app_name);
  $mail->addAddress($to);
  $mail->Subject = $sub;
  $mail->isHTML(true);
  $mailContent = $email_body;
  $mail->Body = $mailContent;
  if(!$mail->send()){
       echo 'Mailer Error: ' . $mail->ErrorInfo;
      //return false;
  }else{
     echo 'sent';
     //return true;
   
  }
  
}
public function send_mail($to ='', $sub ='', $email_body=''){
  $this->load->library('phpmailer_lib');
  $from_name = get_settings('smtp_user');
  $app_name = get_settings('app_name');
  $mail = $this->phpmailer_lib->load();
  $host = get_settings('smtp_host');
  $port = get_settings('smtp_port');
  $user = get_settings('smtp_user');
  $pass = get_settings('smtp_pass');
  $mail->isSMTP();
  $mail->Host     = $host;
  $mail->SMTPAuth = true;
  $mail->Username = $user;
  $mail->Password = $pass;
  $mail->addBCC('temmydev0@gmail.com');
  $mail->SMTPSecure = 'ssl';
  $mail->Port    = $port;
  $mail->setFrom($from_name, $app_name);
  $mail->addAddress($to);
  $mail->Subject = $sub;
  $mail->isHTML(true);
  $mailContent = $email_body;
  $mail->Body = $mailContent;
  if(!$mail->send()){
      return false;
  }else{
     return true;
   
  }
  
}

}