<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Admin extends CI_Controller {
	function __construct(){
    parent::__construct();
	$this->load->database();
   }
  public function index() {
	$page_data['page_name'] = "login";
    $page_data['page_title'] = 'Admin Login';
    $this->load->view('backend/login', $page_data);
    }
   

    public function adminLogin() 
{
        $email = $this->input->post('txtemail');
        $password = $this->input->post('txtpasskode');
        $result = $this->Admin_model->login($email);
        if(empty($result))
        {
            $this->session->set_flashdata('error_message', 'Email is invalid. Please try again!');
            redirect(adminController().'index');
        }
    if (password_verify($password, $result['password'])) 
    {
      //$this->session->set_userdata('member_session') == true;
     $this->session->set_userdata('super_admin_session', '1');
       $this->session->set_userdata('login_id', $result['admin_id']);
       $this->session->set_userdata('email', $result['email']);
      redirect(adminController().'dashboard');
    } else {
        $this->session->set_flashdata('error_message', 'Password is invalid. Please try again!');
        redirect(adminController().'index');
    }      
}
public function cacreg()
{
    if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "cacreg";
        $page_data['list'] = $this->db->get_where('cacreg',array('status'=>'pending'));
        $page_data['page_title'] = 'Submitted CAC Request';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function updateCACreg()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('table_id');
    $data['comp_name'] = $this->escapeString('comp_name');
    $data['alt_comp_name'] = $this->escapeString('alt_comp_name');;
    $data['share_cap'] = $this->escapeString('share_cap');
    $data['comp_addr'] = $this->escapeString('comp_addr');
    $data['res_addr'] = $this->escapeString('res_addr');
    $data['bus_nature'] = $this->escapeString('bus_nature');
    $data['phone_num'] = $this->escapeString('phone_num');
    $data['status'] = $this->escapeString('status');
    $this->db->where('id',$id);
    $this->db->update('cacreg',$data);
   $this->session->set_flashdata('success_msg', 'Record updated successfully');
     redirect(adminController().'cacreg');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updateActivationStatus()
 {
    if ($this->session->userdata('super_admin_session') == false) {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');    
    redirect(adminController().'logout');
    }
    $userid = $this->escapeString('userid');
    $details = $this->db->get_where('account', array('accountid' =>$userid))->row_array();
    if($details['activation_status'] == '1'){
        $data['activation_status'] = '0';
        }else{
        $data['activation_status'] = '1';
        }
    $this->db->where('accountid',$userid);
    $this->db->update('account',$data);
    $this->session->set_flashdata('success_alert', 'Record updated successfully');
    echo '1';
 }
public function uploadAssets(){
     if ($this->session->userdata('super_admin_session') == true) {
            $this->Admin_model->uploadAssets();
            $this->session->set_flashdata('success_msg', 'Changes has been saved');
            redirect(adminController().'siteSettings');
        }else {
      $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
        redirect(adminController().'index');
  }
}
public function send_broadcast(){
    if ($this->session->userdata('super_admin_session') == true) {
        $id = '1';
        $subject = $this->escapeString('subject');
        $body = $this->input->post('message');
        $status = $this->input->post('status');
        $being_sent_to = $this->input->post('being_sent_to');
       if($being_sent_to =='4'){
         $recipient = $this->escapeString('single_email');
         $page_data['message'] = $body;
         $page_data['title'] = $subject;
        $page_data['email'] = $recipient;
        $message = $this->load->view('Auth/Emails/bulkemail',$page_data,TRUE);
         $this->send_mail($recipient,$subject,$message);
         $this->session->set_flashdata('success_msg', 'Message has been sent to Member(s)');
       redirect(adminController().'siteBroadcast');
        }else{
        $data['usertype'] = $being_sent_to;
        $data['title'] = $subject;
        $data['body'] = $body;
        $data['status'] = $status;
        $this->db->where('id',$id);
        $this->db->update('broadcast',$data);
        $get_all_registered_members = $this->db->get('account');
        if($being_sent_to !='4'){
            foreach ($get_all_registered_members->result_array()  as $members){
            $data_user['broadCastEmailStatus'] = '1';
                if($being_sent_to !='0'){
                $this->db->where('package_id',$being_sent_to);
                }else{
                $activation_status = '0';
                $this->db->where('activation_status',$activation_status);
                }
            $this->db->update('account',$data_user);
              }
        }
          $this->session->set_flashdata('success_msg', 'Message has been scheduled');
       redirect(adminController().'siteBroadcast');
        /*
        $get_all_registered_members = $this->db->get('account');
        foreach ($get_all_registered_members->result_array()  as $members){
           $user_list[] = $members['email']; 
        }
        $user_list = join(',',$user_list);
        $users  = explode(',', $user_list);
        foreach ($users as $key => $user) {
                if ($user !== '') {
                    $this->send_mail($user,$subject,$body);
                }
            }
      $this->session->set_flashdata('success_msg', 'Message has been sent to Member(s)');
       redirect(adminController().'siteBroadcast');
       */
        }
    }else{
       redirect(adminController().'index');
    }
}
public function update_site(){
     if ($this->session->userdata('super_admin_session') == true) {
            $this->Admin_model->update_system_settings();
            $this->session->set_flashdata('success_msg', 'Changes has been saved');
            redirect(adminController().'siteSettings');
        }else {
      $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
        redirect(adminController().'index');
  }
}
public function logout() {
      $this->admin_session_destroy();
    redirect(adminController().'index');
    }
    public function admin_session_destroy() {
      $this->session->unset_userdata('login_id');
      $this->session->unset_userdata('email');
     if ($this->session->userdata('super_admin_session') == 1) {
        $this->session->unset_userdata('super_admin_session');
      }
    }
public function dashboard() {
	if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "dashboard";
        $page_data['page_title'] = 'Dashboard';
        $parmeter = $this->input->post('parmeter');		
	$parameter_value = $this->input->post('parameter_value');
        if((isset($_GET['user_id']))&&(!empty($_GET['user_id'])))
	{       $user_id = $_GET['user_id'];
	    	$page_data['history'] = $this->Admin_model->get_all_transactionuser($user_id);
	}else{
	$page_data['history'] = $this->Admin_model->get_all_Dashboardtransaction($parmeter,$parameter_value); 
	}
       $this->load->view('backend/index', $page_data);
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }
}
public function depositDetails($id)
{
    if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "depositDetails";
        $page_data['list'] = $this->db->get_where('deposits',array('id'=>$id))->row_array();
        $page_data['page_title'] = 'Wallet Deposits Details';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}

public function searchTransaction()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $parmeter="";$parameter_value="";$submodule="";$transactiondate="";$condate="";$status="";
    if((isset($_POST['parmeter']))&&(!empty($_POST['parmeter']))){
        $parmeter = $this->escapeString('parmeter');
    }
    if((isset($_POST['parameter_value']))&&(!empty($_POST['parameter_value']))){
        $parameter_value = $this->escapeString('parameter_value');
    }
    if((isset($_POST['submodule']))&&(!empty($_POST['submodule']))){
        $submodule = $this->escapeString('submodule');
    }
    if((isset($_POST['status']))&&(!empty($_POST['status']))){
        $status = $this->escapeString('status');
    }
    if((isset($_POST['transactiondate']))&&(!empty($_POST['transactiondate']))){
        $transactiondate = $this->escapeString('transactiondate');
        $condate = date("Y-m-d", strtotime($transactiondate));
    }
    //echo $status;
    //exit;
    $search = $this->Admin_model->searchTransaction($parmeter,$parameter_value,$submodule,$condate,$status);
    $page_data['page_name'] = "transactions";
    $page_data['history'] = $search;
    $page_data['page_title'] = 'Transactions';
    $this->load->view('backend/index', $page_data);
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }
}
public function ChangeDateFormat($date)
{
      $tdate = str_replace('/', '-', $date);
      return $tdate;
    // $currentDate = date('Y-m-d', strtotime($date));
}
public function salesAnalysis()
{
if ($this->session->userdata('super_admin_session') == true) {
    
    if(isset($_POST['search']))
    {
    $date = $this->escapeString('fromDate');
    }else{
     $date  = date('Y-m-d');
    }
    $page_data['services'] = $this->db->get_where('sub_module',array('status' => 1));
    $page_data['page_name'] = "salesAnalysis";
    $page_data['date'] = $this->ChangeDateFormat($date);
    $page_data['page_title'] = 'Sales Analysis '.$this->ChangeDateFormat($date);
    $this->load->view('backend/index', $page_data);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  } 
}
public function create_session($result)
  {
      //$this->session_destroy();
      if($result['referral_code']  == '')
       {
         $uref['referral_code'] = $this->random_strings('4');
         $this->db->where('accountid',$result['accountid']);
        $this->db->update('account',$uref);
       }
       $session_id = sha1(time());
        $myTime = date('Y-m-d H:i:s', time());
        $ip_address = $this->input->ip_address(); 
      $this->Auth_model->update_session_id($result['accountid'],$session_id); 
      $session_data = array(
                    'loginId' => $session_id,
                    'session_id' => session_id(),
                    'loginName' => $result['fullname'],
                    'loginPhone' => $result['phone'],
                    'member_session' => TRUE
                );
        $this->session->set_userdata($session_data);
        return $session_data;
  }
public function loginas($userid)
{
    if ($this->session->userdata('super_admin_session') == true) {
        $udetails = get_user_info($userid);
        $this->create_session($udetails);
        redirect('dashboard');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function loginHistory()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "loginHistory";
        $date = date('Y-m-d');
        if((isset($_GET['user_id']))&&(!empty($_GET['user_id']))){
        $page_data['data'] = $this->db->get_where('daily_login',array('user_id'=>$_GET['user_id']));
        }else{
        $page_data['data'] = $this->db->get_where('daily_login',array('date_login'=>$date));    
        }
        $page_data['page_title'] = 'Login History';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function reverse($id)
{
    if ($this->session->userdata('super_admin_session') == true) {
        $getDetails = $this->db->get_where('transactions',array('id'=>$id))->row_array();
        $reversedCode = $this->db->get_where('status_code',array('value'=>'reversed'))->row_array();
        $userDetails = get_user_info($getDetails['user_id']);
        $newbal = ($userDetails['wallet_balance'] + $getDetails['charge']);
        $sub = 'Trasaction ID ('.$getDetails['order_id'].') Reversed';
        $body = 'Dear '.$userDetails['fullname'].', <br/><br/> This is to nofity you that transaction with reference ID: '.$getDetails['order_id'].' has just been reversed. See details below <br/><br/>
        Description: '.$getDetails['description'].' <br/> Beneficiary: '.$getDetails['recipient'].' <br/> Transaction Date: '.$getDetails['date_added'].'<br/> Reversed Date: '.date('Y-m-d').'<br/> Previous Balance: NGN '.$userDetails['wallet_balance'].' <br/>New Balance: '.$newbal.' <br/>Transaction Ref: '.$getDetails['order_id'].' <br/><br/>Regards<br/> '.get_settings('app_name').' Team';
     $this->User_model->do_CreditWallet($userDetails['accountid'],$getDetails['charge'],$wallet_type='wallet_balance');
     $verify_transaction = $this->db->select('*')->from('complaints')->where('reference_id',$getDetails['order_id'])->limit('1')->get();
     if($verify_transaction->num_rows() > 0){$this->Admin_model->update_complaint_status($getDetails['order_id'],$response="Reversed"); }
     $data['status'] = $reversedCode['code'];$this->db->where('id',$id);$this->db->update('transactions',$data);
     $this->send_mail($userDetails['email'],$sub,$body);
     $this->session->set_flashdata('success_alert', 'Record successfully updated');
     redirect(adminController().'trans_details/'.$id);
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }   
}
public function updateTransactionStatus()
{
    $tid = $this->escapeString('tid');
    $status = $this->escapeString('status');
    $data['status'] = $status;$this->db->where('id',$tid);$this->db->update('transactions',$data);
    $this->session->set_flashdata('success_alert', 'Record successfully updated');
    redirect(adminController().'trans_details/'.$tid);
}
public function transactionbySessionID($session_id)
{
      if ($this->session->userdata('super_admin_session') == true) {
    $page_data['history'] = $this->db->get_where('transactions',array('session_id'=>$session_id));
   $page_data['page_name'] = "transactions";
   $page_data['page_title'] = 'Transactions';
   $this->load->view('backend/index', $page_data); 
      }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }   
}
public function transactions()
{
   if ($this->session->userdata('super_admin_session') == true) {
       if((isset($_GET['user_id']))&&(!empty($_GET['user_id']))){
         $page_data['history'] = $this->Admin_model->get_all_transactionuser($_GET['user_id']); 
      }else{
    $page_data['history'] = $this->Admin_model->get_all_transaction(); 
      }
	$page_data['page_name'] = "transactions";
       $page_data['page_title'] = 'Transactions';
         $this->load->view('backend/index', $page_data);		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function changePassword()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "changePassword";
        $page_data['page_title'] = 'Change Password';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }      
}
public function fetchDeposits($status)
{
    $this->db->where('payment_status',$status);
    $this->db->order_by('id','DESC');
    $query = $this->db->get('deposits');
    return $query;
}
public function deposits($status)
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "deposits";
        $page_data['data'] = $this->fetchDeposits($status);
        $page_data['page_title'] = 'Wallet Deposits';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function paymentGateways()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "paymentGateways";
        $page_data['page_title'] = 'Payment Gateways';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function deleteEmptyRow()
{
    $mpty = '';
    $this->db->where('email',$mpty);
    $this->db->delete('account');
    echo 'All done';
}
public function deleteUserAccount($id)
{
    if ($this->session->userdata('super_admin_session') == true) {
       $this->db->where('user_id',$id);
        $this->db->delete('deposits');
        
        $this->db->where('user_id',$id);
        $this->db->delete('transactions');
        
        $this->db->where('accountid',$id);
        $this->db->delete('account');
       
       $this->session->set_flashdata('success_alert', 'Record successfully deleted');
    redirect(adminController().'customers/1');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function deleteAdmin($id)
{
    if ($this->session->userdata('super_admin_session') == true) {
       $this->db->where('admin_id',$id);
        $this->db->delete('admin');
        $this->session->set_flashdata('success_alert', 'Record successfully deleted');
    redirect(adminController().'adminUser');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function deleteBlacklist($id)
{
    if ($this->session->userdata('super_admin_session') == true) {
       $this->db->where('id',$id);
        $this->db->delete('blacklist');
        $this->session->set_flashdata('success_alert', 'Record successfully deleted');
    redirect(adminController().'blacklist');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function updateBanner()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = $this->db->get_where('mobile_slider',array('id'=>$id))->row_array();
    if($details['status'] == '1')
    {
        $data['status'] = '0';
    }else{
        $data['status'] = '1';
    }
    $this->db->where('id',$id);
    $this->db->update('mobile_slider',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
      redirect(adminController().'banner');
  }  
}
public function removeApiProvider($id)
{
    $this->db->where('id',$id);
    $this->db->delete('api_provider');
     $this->session->set_flashdata('success_alert',('Provider deleted successfully'));
    redirect(adminController().'apiProviders');
}
public function deleteSlider($id)
{
    $this->db->where('id',$id);
    $this->db->delete('mobile_slider');
     $this->session->set_flashdata('success_alert',('Slide deleted successfully'));
    redirect(adminController().'banner');
}
public function random_strings($length_of_string)
{
$str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
return substr(str_shuffle($str_result),
                   0, $length_of_string);
}
public function addBanner()
{
    if ($this->session->userdata('super_admin_session') == true) {
        if($_FILES['imagefile']['name'] != "") {
        $fileRename = $this->random_strings(6);
        $path = 'assets/assets/images/banner/'. $fileRename . '.jpg';
        $link = base_url().$path;
        move_uploaded_file($_FILES['imagefile']['tmp_name'], $path);
        $data['image_url'] = $link;
        $this->db->insert('mobile_slider', $data);
        $this->session->set_flashdata('success_alert',('Slide added successfully'));
       }else{
           $this->session->set_flashdata('error_message',('Image file not found'));
       }
    redirect(adminController().'banner');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function addAdminUser()
{
    if ($this->session->userdata('super_admin_session') == true) {
        $data['email'] = $this->escapeString('email');
        $data['password'] = password_hash($this->escapeString('password'), PASSWORD_BCRYPT);
        $data['account_name'] = $this->escapeString('accountName');
        $this->db->insert('admin',$data);
        $this->session->set_flashdata('success_alert', 'Record successfully updated');
    redirect(adminController().'adminUser');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function doPasswordUpdate()
{
if ($this->session->userdata('super_admin_session') == true) {
    $current_password =$this->escapeString('oldpassword');
    $new_password = $this->escapeString('newPassword');
    $confirm_password = $this->escapeString('confirmPassword');
    $adetails = $this->Admin_model->user_details($this->session->userdata('login_id'))->row_array();
    if($new_password != $confirm_password)
    {
     $this->session->set_flashdata('error_message', 'New password and confirm new password does not match');
       redirect(adminController().'changePassword');
        exit;    
    }
   if(password_verify($current_password, $adetails['password']))
    {
        $data['password'] = password_hash($current_password, PASSWORD_BCRYPT);
         $this->db->where('admin_id', $adetails['admin_id']);
        $this->db->update('admin', $data);
         $this->session->set_flashdata('success_msg', 'Your Account Password has been successfully updated');
       redirect(adminController().'changePassword');
        exit; 
     
    }else{
       $this->session->set_flashdata('error_message', 'Current password is invalid');
     redirect(adminController().'changePassword');
        exit; 
    }
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function addBlacklist()
{
    if ($this->session->userdata('super_admin_session') == true) {
        $data['phonenumber'] = $this->escapeString('phonenumber');
        $this->db->insert('blacklist',$data);
        $this->session->set_flashdata('success_alert', 'Record successfully updated');
    redirect(adminController().'blacklist');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function suspendedUsers()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "suspendedUsers";
        $page_data['page_title'] = 'Suspended Customers';
        $page_data['data'] = $this->db->get_where('account',array('suspend'=>'1'));
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function blacklist()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "blacklist";
        $page_data['page_title'] = 'Blacklist';
        $page_data['data'] = $this->db->get('blacklist');
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function plans()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "plans";
        $page_data['page_title'] = 'Plan Management';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function searchCustomer()
{
   if ($this->session->userdata('super_admin_session') == true) {
       if((isset($_POST['searchBy']))&&(!empty($_POST['searchBy']))){
       $searchBy = $this->escapeString('searchBy');
       $inputvalue = $this->escapeString('inputvalue');
       $page_data['data'] = $this->db->get_where('account', array($searchBy =>$inputvalue));
       }else{
           $page_data['data'] = fetchUserbyStatus($status='');
       }
        $page_data['page_name'] = "customers";
        
        $page_data['page_title'] = 'Customer Management';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }       
}
public function customers($status)
{
    if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "customers";
        $page_data['data'] = fetchUserbyStatus($status);
        $page_data['page_title'] = 'Customer Management';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function customerDetails($id)
{
     if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "customerDetails";
        $page_data['data'] = get_user_info($id);
        $page_data['page_title'] = 'Customer Details';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function fetchCablePlans()
{
    $this->db->order_by('cabletv','Asc');
    $query = $this->db->get('cabletv');
    return $query;
}
public function cablePlans()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "cablePlans";
        $page_data['plans'] = $this->fetchCablePlans();
        $page_data['page_title'] = 'Cable Plans Management';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}
public function dataplans()
{
   if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "dataplans";
        $page_data['network_type'] = $this->db->where('parent_id','2')->get('sub_module')->result_array();
        if((isset($_GET['type'])) &&(!empty($_GET['type']))){
            $type = $_GET['type'];
        $page_data['plans'] = $this->db->where('subtype',$type)->get('databundles');
        }else{
            $page_data['plans'] = $this->db->order_by('subtype')->get('databundles');
        }
        $page_data['page_title'] = 'Data Plans Management';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }     
}

public function setService($id)
{
  if ($this->session->userdata('super_admin_session') == true) {
      $details = get_SubmodulebyModule($id);
      $moduleDetails = get_module($id);
      $page_data['details'] = $details;
        $page_data['page_name'] = "setService";
        $page_data['moduleDetails'] = $moduleDetails;
        $page_data['page_title'] = $moduleDetails['module'].' Settings';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function siteSettings()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "siteSettings";
        $page_data['page_title'] = 'Site Settings';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function generalSettings()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "generalSettings";
        $page_data['page_title'] = 'General Settings';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function apiProviders()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "apiProviders";
        $page_data['page_title'] = 'API Providers';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}

public function siteBroadcast()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "siteBroadcast";
        $page_data['page_title'] = 'Send Broadcast';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function siteNotification()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "siteNotification";
        $page_data['page_title'] = 'Site Notification';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function siteConfiguration()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "siteConfiguration";
        $page_data['page_title'] = 'Site Configuration';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}

public function identitySettings()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "identitySettings";
        $page_data['page_title'] = 'Identity Settings';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}

public function banner()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "banner";
         $page_data['data'] = $this->db->get('mobile_slider');
        $page_data['page_title'] = 'Banner Management';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}

public function services()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "services";
        $page_data['page_title'] = 'Modules Status';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function adminUser()
{
  if ($this->session->userdata('super_admin_session') == true) {
      $adetails = $this->Admin_model->user_details($this->session->userdata('login_id'))->row_array();
      $this->db->where('admin_id !=',$adetails['admin_id']);
      $admins = $this->db->get('admin');
        $page_data['page_name'] = "adminUser";
        $page_data['page_title'] = 'Admin User';
        $page_data['data'] = $admins;
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function updateAdminStatus()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = $this->db->get_where('admin',array('admin_id' => $id))->row_array();
    if($details['status'] == '1')
    {
        $data['status'] = '0';
    }else{
        $data['status'] = '1';
    }
    $this->db->where('admin_id',$id);
    $this->db->update('admin',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    $this->session->set_flashdata('success_alert', 'Record successfully updated');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function unsuspendUser()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = get_user_info($id);
    if($details['suspend'] == '1')
    {
        $data['suspend'] = '0';
    }else{
        $data['suspend'] = '1';
    }
    $this->db->where('accountid',$id);
    $this->db->update('account',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    $this->session->set_flashdata('success_alert', 'Record successfully updated');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updatePaymentGatewayStatus()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = payment_getways($id);
    if($details['gateway_status'] == '1')
    {
        $data['gateway_status'] = '0';
    }else{
        $data['gateway_status'] = '1';
    }
    $this->db->where('gateway_id',$id);
    $this->db->update('payment_gateways',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    $this->session->set_flashdata('success_alert', 'Record successfully updated');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updateCableplanStatus()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = get_CablePlan($id);
    if($details['tv_status'] == '1')
    {
        $data['tv_status'] = '0';
    }else{
        $data['tv_status'] = '1';
    }
    $this->db->where('id',$id);
    $this->db->update('cabletv',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updateModuleStatus()
{
     if ($this->session->userdata('super_admin_session') == true) {
          $id = $this->escapeString('id');
          $details = get_module($id);
    if($details['status'] == '1')
    {
        $data['status'] = '0';
    }else{
        $data['status'] = '1';
    }
    $this->db->where('id',$id);
    $this->db->update('module',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    echo json_encode($arr);
     }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  

}
public function updateDataplanStatus()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = get_Databundles($id);
    if($details['status'] == '1')
    {
        $data['status'] = '0';
    }else{
        $data['status'] = '1';
    }
    $this->db->where('package_id',$id);
    $this->db->update('databundles',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updateSubModuleStatus()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = get_Submodule($id);
    if($details['status'] == '1')
    {
        $data['status'] = '0';
    }else{
        $data['status'] = '1';
    }
    $this->db->where('id',$id);
    $this->db->update('sub_module',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updateProviders()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $details = get_network($id);
    if($details['status'] == '1')
    {
        $data['status'] = '0';
    }else{
        $data['status'] = '1';
    }
    $this->db->where('id',$id);
    $this->db->update('network',$data);
    $arr = array('message' => 'Record successfully updated', 'title' => 'Success');
    echo json_encode($arr);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function deleteAPI($id)
{
    if ($this->session->userdata('super_admin_session') == true) {
    $this->db->where('id',$id);
    $this->db->delete('api_provider');
    $this->session->set_flashdata('success_msg', 'Record deleted successfully');
     redirect(adminController().'apiSettings');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
   }  
}

public function editSubModuleData()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $moduleid = $this->escapeString('moduleid');
    $data['name'] = $this->escapeString('name');
    $data['network_id'] = $this->escapeString('network');
    $data['api'] = $this->escapeString('api');
    $data['api_code'] = $this->escapeString('api_code');
    $data['parent_id'] = $this->escapeString('moduleid');
    if(isset($_POST['user_percent'])){
    $data['user_percent'] = $this->escapeString('user_percent');
    $data['reseller_percent'] = $this->escapeString('reseller_percent');
    $data['api_percent'] = $this->escapeString('api_percent');
    }
     $data['ref_bonus'] = $this->escapeString('ref_bonus');
    $this->db->where('id',$id);
    $this->db->update('sub_module',$data);
    $this->session->set_flashdata('success_msg', 'Record updated successfully');
     redirect(adminController().'setService/'.$moduleid);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}

public function editDataPlans()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('package_id');
    $subModule = $this->escapeString('subtype');
    $suDetails = get_Submodule($subModule);
    $data['package_name'] = $this->escapeString('package_name');
    $data['subtype'] = $subModule;
    $data['price'] = $this->escapeString('price');
    $data['user_price'] = $this->escapeString('user_price');
    $data['reseller_price'] = $this->escapeString('reseller_price');
    $data['api_price'] = $this->escapeString('api_price');
    $data['network_id'] = $suDetails['network_id'];
    $data['provider_code'] = $this->escapeString('api_code');
    $this->db->where('package_id',$id);
    $this->db->update('databundles',$data);
    $this->session->set_flashdata('success_msg', 'Record updated successfully');
     redirect(adminController().'dataplans');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function editCablePlan()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $subModule = $this->escapeString('subtype');
    $suDetails = get_Submodule($subModule);
    $data['package_name'] = $this->escapeString('package_name');
    $data['subtype'] = $subModule;
    $data['price'] = $this->escapeString('price');
    $data['user_price'] = $this->escapeString('user_price');
    $data['reseller_price'] = $this->escapeString('reseller_price');
    $data['api_price'] = $this->escapeString('api_price');
    $data['cabletv'] = $suDetails['network_id'];
    $data['provider_code'] = $this->escapeString('api_code');
    $this->db->where('id',$id);
    $this->db->update('cabletv',$data);
   $this->session->set_flashdata('success_msg', 'Record added successfully');
     redirect(adminController().'cablePlans');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function addAPIProvider()
{
    if ($this->session->userdata('super_admin_session') == true) {
   // $id = $this->escapeString('id');
    $data['provider_name'] = $this->escapeString('provider_name');
    $data['apiType'] = $this->escapeString('apiType');
    $data['user_id'] = $this->escapeString('user_id');
    $data['api_key'] = $this->escapeString('api_key');
    $data['endpoint'] = $this->escapeString('endpoint');
    $data['subModule'] = '33';//$this->escapeString('subModule');
    $data['password'] = $this->escapeString('password');
    $this->db->insert('api_provider',$data);
   $this->session->set_flashdata('success_msg', 'Record added successfully');
     redirect(adminController().'apiProviders');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updateAPIProvider()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $data['provider_name'] = $this->escapeString('provider_name');
    $data['apiType'] = $this->escapeString('apiType');;
    $data['api_key'] = $this->escapeString('api_key');
    $data['user_id'] = $this->escapeString('user_id');
    $data['endpoint'] = $this->escapeString('endpoint');
    $data['subModule'] = '33';//$this->escapeString('subModule');
    $data['password'] = $this->escapeString('password');
    $this->db->where('id',$id);
    $this->db->update('api_provider',$data);
   $this->session->set_flashdata('success_msg', 'Record updated successfully');
     redirect(adminController().'apiProviders');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function updatePaymentGateway()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('gateway_id');
    $data['gateway_name'] = $this->escapeString('gateway_name');
    $data['charge_type'] = $this->escapeString('charge_type');;
    $data['gateway_percent'] = $this->escapeString('gateway_percent');
    $data['pk_live'] = $this->escapeString('pk_live');
    $data['sk_live'] = $this->escapeString('sk_live');
    $data['contract_code'] = $this->escapeString('contract_code');
    $this->db->where('gateway_id',$id);
    $this->db->update('payment_gateways',$data);
   $this->session->set_flashdata('success_msg', 'Record added successfully');
     redirect(adminController().'paymentGateways');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function addCablePlan()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $subModule = $this->escapeString('subtype');
    $suDetails = get_Submodule($subModule);
    $data['package_name'] = $this->escapeString('package_name');
    $data['subtype'] = $subModule;
    $data['price'] = $this->escapeString('price');
    $data['user_price'] = $this->escapeString('user_price');
    $data['reseller_price'] = $this->escapeString('reseller_price');
    $data['api_price'] = $this->escapeString('api_price');
    $data['cabletv'] = $suDetails['network_id'];
    $data['provider_code'] = $this->escapeString('api_code');
    $this->db->insert('cabletv',$data);
    $this->session->set_flashdata('success_msg', 'Record added successfully');
     redirect(adminController().'cablePlans');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function addDataPlan()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $subModule = $this->escapeString('subtype');
    $suDetails = get_Submodule($subModule);
    $data['package_name'] = $this->escapeString('package_name');
    $data['subtype'] = $subModule;
    $data['price'] = $this->escapeString('price');
    $data['user_price'] = $this->escapeString('user_price');
    $data['reseller_price'] = $this->escapeString('reseller_price');
    $data['api_price'] = $this->escapeString('api_price');
    $data['network_id'] = $suDetails['network_id'];
    $data['provider_code'] = $this->escapeString('api_code');
    $this->db->insert('databundles',$data);
    $this->session->set_flashdata('success_msg', 'Record added successfully');
     redirect(adminController().'dataplans');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function addSubModuleData()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $moduleid = $this->escapeString('moduleid');
    $data['name'] = $this->escapeString('name');
    $data['network_id'] = $this->escapeString('network');
    $data['api'] = $this->escapeString('api');
    $data['api_code'] = $this->escapeString('api_code');
    $data['parent_id'] = $this->escapeString('moduleid');
    $data['ref_bonus'] = $this->escapeString('ref_bonus');
    $this->db->insert('sub_module',$data);
    $this->session->set_flashdata('success_msg', 'Record updated successfully');
     redirect(adminController().'setService/'.$moduleid);
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
/*
public function addApiProvider()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $data['provider_name'] = $this->escapeString('provider_name');
    $data['endpoint'] = $this->escapeString('endpoint');
    $data['apiType'] = $this->escapeString('apiClass');
    $data['api_key'] = $this->escapeString('api_key');
    $this->db->insert('api_provider',$data);
    $this->session->set_flashdata('success_msg', 'Record added successfully');
     redirect(adminController().'apiSettings');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
*/
public function editApiProvider()
{
     if ($this->session->userdata('super_admin_session') == true) {
    $id = $this->escapeString('id');
    $data['provider_name'] = $this->escapeString('provider_name');
    $data['endpoint'] = $this->escapeString('endpoint');
    $data['apiType'] = $this->escapeString('apiClass');
    $data['api_key'] = $this->escapeString('api_key');
    $this->db->where('id',$id);
    $this->db->update('api_provider',$data);
    $this->session->set_flashdata('success_msg', 'Record updated successfully');
     redirect(adminController().'apiSettings');
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}

public function getsubModule()
{
    if ($this->session->userdata('super_admin_session') == true) {
        $network = $this->escapeString('network');
        $this->db->where('network');
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}
public function networkSettings()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "networkSettings";
        $page_data['page_title'] = 'Providers Settings';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}
public function apiSettings()
{
  if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "apiSettings";
        $page_data['page_title'] = 'API Settings';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }    
}

public function configurations()
{
    if ($this->session->userdata('super_admin_session') == true) {
        $page_data['page_name'] = "configuration";
        $page_data['page_title'] = 'Configuration';
         $this->load->view('backend/index', $page_data);;		
}else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }  
}

public function trans_details($id)
{
     if ($this->session->userdata('super_admin_session') == true) {
         
         if($id =='')
         {
             redirect(adminController().'transaction');
             exit;
         }
        $page_data['page_name'] = "trans_details";
        $page_data['data'] = $this->Admin_model->get_transaction_single($id)->row_array();
        $page_data['page_title'] = 'Transaction Details';
        $this->load->view('backend/index', $page_data);
        }else {
        $this->session->set_flashdata('error_message', 'Access denied. Please login again!');    
     redirect(adminController().'logout');
  }
}
public function member_details($member_id='') {
  if ($this->session->userdata('super_admin_session') == true) {
    $page_data['page_name'] = "member_details";
        $page_data['page_title'] = 'Member Details';
        $page_data['member_id'] = $member_id;
        $page_data['details'] = get_user_info($member_id);
        $this->load->view('backend/index', $page_data);
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');    
    redirect(adminController().'logout');
  }
}
public function uniqueid()
      {
        $un = substr(number_format(time() * rand(),0,'',''),0,12);
        return $un;
      }
public function escapeString($string) {
    return remove_invisible_characters(html_escape($this->input->post($string)));
  }
 
 public function updateSystemAccount()
 {
    if ($this->session->userdata('super_admin_session') == false) {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');    
    redirect(adminController().'logout');
    }
    $id = '1';
    $data['bank_name'] = $this->escapeString('bank_name');
    $data['account_name'] = $this->escapeString('account_name');
    $data['account_number'] = $this->escapeString('account_number');
    $data['account_type'] =$this->escapeString('account_type');
    $this->db->where('id',$id);
    $this->db->update('system_bank_accounts',$data);
    $this->session->set_flashdata('success_alert', 'Record updated successfully');
    redirect(adminController().'paymentGateways');
 }
 public function updateUser()
 {
    if ($this->session->userdata('super_admin_session') == false) {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');    
    redirect(adminController().'logout');
    }
    $id = $this->escapeString('accountid');
    $data['fullname'] = $this->escapeString('fullname');
    //$data['email'] = $this->escapeString('email');
    //$data['phone'] = $this->escapeString('phone');
    $data['api_access'] =$this->escapeString('api_access');
    $data['security_pin'] =$this->escapeString('security_pin');
    if((isset($_POST['passwordUpdate']))&&(!empty($_POST['passwordUpdate'])))
    {
    $password = $this->escapeString('passwordUpdate');
     $data['password'] = password_hash($password, PASSWORD_BCRYPT);
    }
    $data['dailyLimit'] = $this->escapeString('dailyLimit');
     $data['dailyReversal'] =$this->escapeString('dailyReversal');
    $data['package_id'] =$this->escapeString('package_id');
    $data['kyc_approve'] =$this->escapeString('kyc_approve');
    $this->db->where('accountid',$id);
    $this->db->update('account',$data);
    $this->session->set_flashdata('success_alert', 'Record updated successfully');
    redirect(adminController().'customerDetails/'.$id);
 }
  public function do_register() 
{
     if ($this->session->userdata('super_admin_session') == false) {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');    
    redirect(adminController().'logout');
  }
    $this->load->helper('email');
    $this->load->library('form_validation');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
    $phonenumber = $this->escapeString('phonenumber');
    $email = $this->escapeString('email');
    $fullname = $this->escapeString('fullname');
    $password = $this->escapeString('password');
    $password_lenght = strlen($password);
        if($password_lenght < get_settings('password_lenght'))
           {
             $this->session->set_flashdata('error_message', 'Minimum of '.get_settings('password_lenght').' character is required for your password');
             redirect(adminController().'customers/1'); 
             exit;
           }
           
           if((strlen($phonenumber) < '11')||(strlen($phonenumber) > '11'))
           {
             $this->session->set_flashdata('error_message', 'Invalid Phone number detected');
             redirect(adminController().'customers/1');
             exit;
           }
           
           
           if((empty($phonenumber)||empty($email)))
           {
             $this->session->set_flashdata('error_message', 'Email address and Phone Number is required');
              redirect(adminController().'customers/1');
           }
    
    
    $userData = array(
        'email' => $email,
        'phone' => $phonenumber,
        'fullname' => $fullname,
         'password' => password_hash($password, PASSWORD_BCRYPT),
         'referral_code' =>$this->random_strings('4'),
         'date_registered'=> current_datetime(),
         'activation_status' => get_settings('activation_status'),
         
    );
    $checkPhone = $this->Auth_model->check_exist($phonenumber,$email);
             if(($checkPhone == false)){
                $insert = $this->Auth_model->register_new($userData);
               // $key = $this->User_model->create_key_table($insert);
                $this->session->set_flashdata('success_alert', 'Thank you for creating account with us. Your account has been created successfully.');
            redirect(adminController().'customers/1');
             }else{
            $this->session->set_flashdata('error_message', 'Account could not be created. It seems you have account with us. Forget password? please use the forget password link');
           redirect(adminController().'customers/1');
             }
}
public function manualFunding()
{
    if ($this->session->userdata('super_admin_session') == true) {
    $page_data['page_name'] = "manualFunding";
        $page_data['page_title'] = 'Manual Funding';
        $this->load->view('backend/index', $page_data);
    }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');    
    redirect(adminController().'logout');
  }
}
public function manual_topup(){
     if ($this->session->userdata('super_admin_session') == true) {
         $phone = $this->escapeString('user_id');
         $amount = $this->escapeString('amount');
         $actiontype = $this->escapeString('actiontype');
         $wallet_type = 'wallet_balance';//$this->input->post('wallet_type');
         $invoice_number = $this->uniqueid();
        $user = $this->Admin_model->fetch_member($phone)->row_array();
        if(empty($user)){
        $this->session->set_flashdata('error_message', 'Customer does not exist.');
        redirect(adminController().'customerDetails/'.$user['accountid']); 
        }
        if($actiontype == 'credit'){$sign = '+';$alert = 'credited';$function = 'do_CreditWallet';}else{$sign = '-';$alert = 'debited';$function = 'do_DebitWallet';}
        $to = $user['email'];
        $full_name = $user['fullname'];
        $app_name = $this->db->get_where('settings',array('key'=>'app_name'))->row()->value;
        $sub = 'NGN '.$amount.' was '.$alert.' on your account on '.$app_name;
        $user_id = $user['accountid'];
        $new_bal = ($user[$wallet_type] + $amount);
        $getbal = $user[$wallet_type];
        $status = '1';
        $body = 'Dear '.$full_name.', <br/><br/> This is to nofity you that NGN '.$amount.' has just been '.$alert.' to your wallet on '.$app_name.' website as follows <br/><br/>
        Previous Balance: NGN '.$getbal.' <br/>New Balance: '.$new_bal.' <br/>Narration: '.$sub.'<br/>Wallet Type: '.$wallet_type.'<br/>Transaction Ref: '.$invoice_number.' <br/><br/>Regards<br/> '.$app_name.' Team';
        $save_order = $this->User_model->insert_transaction($user_id,$sub,$module_details='6',$validate_number='',$user['phone'],$amount,$amount,$apiRoute='',$invoice_number,$sub_module='',$extra='',$discount='');
        $this->User_model->$function($user_id,$amount,$wallet_type);
        $this->User_model->initiate_fund($user_id,$invoice_number,$amount,$payment_getways='',$payment_status='1',$getbal,$new_bal);
        $updateS['status'] = '1';$this->db->where('id',$save_order);$this->db->update('transactions',$updateS);
        $this->User_model->updateBalances($save_order,$getbal);
        $this->session->set_flashdata('success_msg', 'User balance updated successfully');
        $this->send_mail($to,$sub,$body);
        redirect(adminController().'customerDetails/'.$user['accountid']);
         }else {
    $this->session->set_flashdata('error_message', 'Access denied. Please login again!');
     redirect(adminController().'logout');
  }
}
public function send_mail($to ='', $sub ='', $email_body=''){
  $this->load->library('phpmailer_lib');
  $from_name = get_settings('smtp_user');
  $app_name = get_settings('app_name');
  $mail = $this->phpmailer_lib->load();
  $host = get_settings('smtp_host');
  $port = get_settings('smtp_port');
  $user = get_settings('smtp_user');
  $pass = get_settings('smtp_pass');
  $mail->isSMTP();
  $mail->Host     = $host;
  $mail->SMTPAuth = true;
  $mail->Username = $user;
  $mail->Password = $pass;
  $mail->SMTPSecure = 'ssl';
  $mail->Port    = $port;
  $mail->setFrom($from_name, $app_name);
  $mail->addAddress($to);
  $mail->Subject = $sub;
  $mail->isHTML(true);
  $mailContent = $email_body;
  $mail->Body = $mailContent;
  if(!$mail->send()){
      return false;
  }else{
     return true;
   
  }
  
}
}