<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Account extends CI_Controller {
	function __construct(){
    parent::__construct();
		  $this->load->database();
		if($this->session->userdata('loginId') == false ){
        $this->session->set_flashdata('error_message', 'Access denied! Please login to continue');
        redirect('login');
      }
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
    if(($this->User_model->get_user_by_session($this->session->userdata('loginId')))->num_rows() < 1){
        $this->session->set_flashdata('error_message', 'Access denied! Please login to continue');
        redirect('logout');
        exit;
          }
        if($udetails['suspend'] == '1')
      {
         $this->session->set_flashdata('error_message', 'Your account has been suspended. Please contact support team');
        redirect('login');
        exit;
      }
      if($udetails['security_pin'] == null)
      {
         $this->session->set_flashdata('error_message', 'Secure your account with a 4 digit pin');
        redirect('setPIN');
        exit;
      }
     }
  public function uniqueid()
  {
    $string = generator('15');
    return $string;
  }
  public function planids()
  {
      $page_data['page_name'] = "planids";
    $page_data['page_title'] = 'All Plan ID';
    $page_data['data'] = $this->db->order_by('network_id','Asc')->get_where('databundles', array('status' => 1));
    $this->load->view('Account/planids', $page_data);
  }
   public function developer()
  {
     $page_data['page_name'] = "developer";
    $page_data['page_title'] = 'Developer';
    $this->load->view('Account/index', $page_data); 
  }
  
  public function convertNetwork($network)
  {
      if($network == '01')
      {
          return 'MTN';
      }
      if($network == '02')
      {
          return 'GLO';
      }
      if($network == '03')
      {
          return '9Mobile';
      }
      if($network == '04')
      {
          return 'AIRTEL';
      }
  }
   public function convertCable($network)
  {
      if($network == '01')
      {
          return 'DSTV';
      }
      if($network == '02')
      {
          return 'GOTV';
      }
      if($network == '03')
      {
          return 'STARTIMES';
      }
      if($network == '04')
      {
          return 'SHOWMAX';
      }
  }
  
  public function getDataplans()
  {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
$network = $_GET['network'];
$datatype = $_GET['datatype'];
$networkName = $this->convertNetwork($network);
$return_user_price =$this->User_model->get_user_price($udetails['accountid']);
$networkDetails =  $this->User_model->verifyNetworkId($module='2',$network)->row_array();
$curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => host_site().'dataplan?network='.$network.'&datatype='.$datatype,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Token: '.$udetails['api_key'],
    'Content-Type: application/json'
  ),
));
$response = curl_exec($curl);
curl_close($curl);
$output = '';
$result = json_decode($response,true);
//echo $response;
//exit;
if((isset($result['status'])) && ($result['status'] =='success'))
{
     foreach($result['data'] as $row)
      {
     $output.= '<div class="col-12">
     <div class="d-flex gap-3 w-100">
        <div class="form-check form-check3" style="border: 1px solid '.get_settings('secondary_color').'; border-radius:10px; float:left;">
         <input class="form-check-input dataplan" type="radio" name="dataplan" id="fixed45'.$row['package_id'].'" value="'.$row['package_id'].'" data-name="'.$networkDetails['network_name'].' " data-price="'.$row[$return_user_price].'"/>
                            <label style="border: 1px solid '.get_settings('secondary_color').'; border-radius:10px;" class="form-check-label" for="fixed45'.$row['package_id'].'">
                             <img class="img-fluid icon" style="width:30px; border-radius:50px" src="'.base_url('assets/images/network/'.$networkDetails['network_img']).'" alt="" />
                                <span class="check-box"></span>
                                <span class="name dark-text">'.$row['package_name'].'</span>
                            </label>
                        </div></div></div>';
}
      
      echo $output;
}else{
    echo '<div class="col-12">
     <div class="d-flex gap-3 w-100">
        <div class="form-check form-check3" style="border: 1px solid '.get_settings('secondary_color').'; border-radius:10px; float:left;">
                        <p>No plan found for this network </p>
                        </div></div></div>';
}
  }
  public function getcablePackages()
{
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
$cableid = $_GET['cableid'];
$networkName = strtolower($this->convertCable($cableid));
$curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => host_site().'getCablepackages?cableid='.$networkName,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Token: '.$udetails['api_key'],
    'Content-Type: application/json'
  ),
));
$response = curl_exec($curl);
curl_close($curl);
$output = '<div class="row">';
$result = json_decode($response,true);
if((isset($result['status'])) && ($result['status'] =='success'))
{
     foreach($result['data'] as $row)
      {
     $output.= '<div class="col-lg-4 col-6" style="border: 2px solid '.get_settings('secondary_color').';">
                            <div class="card" style="border: 1px solid '.get_settings('secondary_color').';">
                                <div class="card-body" >
                                    <h5 class="fs-15 text-center fw-semibold pb-1 pt-1" style="border-radius:10px; background-color:'.get_settings('secondary_color').'; color:#fff;">'.$networkName.'</h5>
                                    <div class="d-flex flex-wrap justify-content-evenly">
                                     <input class="form-check-input datasize" id="'.$row['id'].'" type="radio" name="dataplan" value="'.$row['id'].'" data-name="'.$row['package_name'].'" networkname="'.$networkName.'"/>
                                        <h4 class="text-center"style="font-size:15px; font-weight:400; color:#000;">'.$row['package_name'].' </h4>
                                    </div>
                                     <p class="text-center" style="font-size:13px; font-weight:400; color:#000;">'.currency().' '.$row['price'].'</p>
                                    <div class="rounded-bottom rounded-0 text-center" style="height: 6px;">
                                    <button class="btn btn-outline-primary verifyCable" id="verifyCable'.$row['id'].'" onclick="verifyCable('.$row['id'].')"; type="button" style="border-radius:5px; border:1px solid '.get_settings('secondary_color').';font-size:13px; background-color:#fff; color:'.get_settings('secondary_color').'; data-title="'.$row['package_name'].'" networkname="'.$networkName.'">Select</button>
                                   
                                   </div>
                                </div>
                                
                            </div>
                        </div>';
      }
      
      echo $output;
}else{
    $output = '<p>No plan found</p>';
}
}
public function getdatatype() {
$output = '<option value="">Select Data Type</option>';
//$udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
$network = $_GET['network'];
$result = $this->User_model->sub_module($id='2',$network); 
if($result->num_rows() > 0){
foreach($result->result_array() as $list){
 $output.= '<option value="'.$list['id'].'">'.$list['name'].'</option>';
 }
    }else{
       $output.='<option value="">No data type found</option>'; 
    }
    echo $output;
}
 public function updateallDaily()
 {
     /*
    
     $getAll = $this->db->get('transactions');
     if($getAll->num_rows() > 0)
     {
         foreach($getAll->result_array() as $each)
         {
          //    if(strlen($each['security_pin']) !='4'){
             $data['checkReversal'] = '0';
             $this->db->where('id',$each['id']);
             $this->db->update('transactions',$data);
           //   }
         }
     }
     
     echo 'done';
     exit;
     
     $data['dailyReversal'] = '6';
     $this->db->where('dailyLimit','0');
     $this->db->update('account');
     echo 'done';
     */
     
     
 }
  public function escapeString($string) {
    return remove_invisible_characters(html_escape($this->input->post($string)));
  }
  public function index(){
	
    $page_data['page_name'] = "dashboard";
    $page_data['page_title'] = 'Dashboard';
    $this->load->view('Account/index', $page_data);
  }
  public function indexv2(){
	
    $page_data['page_name'] = "includes/virtualAccounts";
    $page_data['page_title'] = 'Dashboard';
    $this->load->view('Account/index', $page_data);
  }
  public function withdraw()
 {
     $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
     $page_data['page_name'] = "withdraw";
    $page_data['page_title'] = 'Cash Withdraw';
    $this->load->view('Account/index', $page_data);
 }
  
  public function passwordChange(){
	$page_data['page_name'] = "passwordChange";
    $page_data['page_title'] = 'Change Password';
    $this->load->view('Account/index', $page_data);
  }
  public function pinChange(){
	$page_data['page_name'] = "pinChange";
    $page_data['page_title'] = 'Change PIN';
    $this->load->view('Account/index', $page_data);
  }
  public function upgrade()
  {
    $page_data['page_name'] = "upgrade";
    $page_data['page_title'] = 'Updrade';
    $this->load->view('Account/index', $page_data);  
  }
  public function spendingAnalysis()
  {
      $day = 'This month';
       $page_data['fdate'] =  date("Y-m-d", strtotime("first day of this month"));
        $page_data['toDate']   =  date("Y-m-d", strtotime("last day of this month"));
       if((isset($_GET['day']))&&(!empty($_GET['day'])))
       {
           $day = $_GET['day'];
           if($day == 'today')
           {
            $page_data['fdate'] =  date('Y-m-d');
            $page_data['toDate']   =  date('Y-m-d');
           }
           if($day == 'this_week')
           {
               $week = date('w');
               $page_data['fdate']= date('Y-m-d', strtotime('-'.$week.' days'));
                $page_data['toDate'] = date('Y-m-d', strtotime('+'.(6-$week).' days'));
           }
           
           if($day == 'this_month')
           {
            $page_data['fdate'] =  date("Y-m-d", strtotime("first day of this month"));
            $page_data['toDate']   =  date("Y-m-d", strtotime("last day of this month"));
           }
           if($day == 'last_week')
           {
               $previous_week = strtotime("-1 week +1 day");
               $start_week = strtotime("last sunday midnight",$previous_week);
            $page_data['fdate'] =  date("Y-m-d", strtotime("last sunday midnight",$previous_week));
            $page_data['toDate']   =  date("Y-m-d", strtotime("next saturday",$start_week));
           }
           if($day == 'last_month')
           {
              $page_data['fdate'] =  date("Y-m-d", strtotime("first day of last month"));
            $page_data['toDate']   =  date("Y-m-d", strtotime("last day of last month"));
           }
           
           
       }
       $page_data['day'] = $day;
       $page_data['page_name'] = "spendingAnalysis";
       $page_data['services'] = get_module_home();
       
    $page_data['page_title'] = 'Expenses Analysis';
    $this->load->view('Account/index', $page_data);  
  }
  public function productDetails($id,$slug)
  {
    $page_data['page_name'] = "productDetails";
    $page_data['item_details'] = $this->User_model->getProductsbyID($id);
    $page_data['page_title'] = 'product Details';
    $this->load->view('Account/index', $page_data);  
  }
  public function blogDetails($id)
  {
    $page_data['page_name'] = "blogDetails";
    $page_data['data'] = getBlog($id)->row_array();
    $page_data['page_title'] = 'Details';
    $this->load->view('Account/index', $page_data);  
  }

  public function generateWemaAccount()
  {
      if(empty(payment_getways('3')['pk_live']))
      {
           $this->session->set_flashdata(array('error_message'=> 'Please set the gateway keys'));
            redirect('addfund'); 
            exit;
      }
      $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
    if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
       $authorization = $this->monify_auth();
       if($udetails['bvn'] ==''){$authType = 'nin';$Authnumber = $udetails['nin'];}else{ $authType = 'bvn';$Authnumber = $udetails['bvn'];}
        $curl = curl_init();
     curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.monnify.com/api/v2/bank-transfer/reserved-accounts",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => json_encode([
        'accountReference'=>$this->uniqueid(),
        'accountName'=>$udetails['fullname'],
        'currencyCode' => "NGN",
        $authType => $Authnumber,
        'contractCode' => $monify_contract,
        'customerEmail'=> $udetails['email'],
        'customerName' => $udetails['fullname'],
        'getAllAvailableBanks' => false,
        'preferredBanks' => ['035']
      ]),
  CURLOPT_HTTPHEADER => array(
     'Content-Type: application/json',
    'Authorization: bearer '.$authorization
  ),
));
       $response = curl_exec($curl);
       // print_r($response);
       //exit;
        curl_close($curl);
        $result = json_decode($response,true);
         if((isset($result['responseBody']['accounts'][0]['accountNumber']))&&(!empty($result['responseBody']['accounts'][0]['accountNumber']))){
            $account_number = $result['responseBody']['accounts'][0]['accountNumber'];
            $data['wema'] = $account_number;
            $this->db->where('accountid',$user_id);
            $this->db->update('account',$data);
            $this->session->set_flashdata('success_msg','Account generated successfully');
            redirect('addfund');
            exit;
            }else{
              //  print_r($response);
              //  exit;
                $this->session->set_flashdata('error_message',print_r($response));
            redirect('addfund');
            exit;
            }
  }
 
  public function do_airtimeCash()
  {
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $pin = $this->escapeString('pin');
     $this->session->set_flashdata(array('success_msg'=> 'Information received successfully'));
    redirect('airtimetocash'); 
    exit;
  }
  public function transferCommission()
  {
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $pin = $this->escapeString('pin');
    $transref = $this->uniqueid();
    $amount = $this->escapeString('amount');
    
    if($amount < 1)
        {
             $this->session->set_flashdata(array('error_message'=> 'Insufficient wallet balance'));
                redirect('referrals'); 
                 exit;
        }
    if($this->checkPIN($pin))
    {
        if($udetails['cash_wallet'] >= $amount)
        {
            $data['cash_wallet'] = ($udetails['cash_wallet'] - $amount);
            $data['wallet_balance'] = ($udetails['wallet_balance'] + $amount);
            $this->db->where('accountid',$udetails['accountid']);
            $this->db->update('subscribers',$data);
            $this->session->set_flashdata(array('success_msg'=> 'Commission has been moved to your wallet'));
            redirect('referrals'); 
            exit;
        }else{
            $this->session->set_flashdata(array('error_message'=> 'Insufficient wallet balance'));
            redirect('referrals'); 
             exit;
        }
    }else{
        $this->session->set_flashdata(array('error_message'=> 'Invalid account PIN'));
            redirect('referrals'); 
             exit;
    }
  }
   public function do_upgrade()
 {
     $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $pin = $this->escapeString('pin');
    $transref = $this->uniqueid();
    $charge = get_settings('upgradeFee');
    if($this->checkPIN($pin))
    {
        if($udetails['wallet_balance'] >= $charge)
        {
            $data['wallet_balance'] = ($udetails['wallet_balance'] - $charge);
            $data['package_id'] = ($udetails['package_id'] + 1);
            $this->db->where('accountid',$udetails['accountid']);
            $this->db->update('account',$data);
            $this->session->set_flashdata(array('success_msg'=> 'Congratulations! You account has been upgraded successfully'));
            redirect('upgrade'); 
        }else{
            $this->session->set_flashdata(array('error_message'=> 'Insufficient wallet balance'));
            redirect('upgrade'); 
        }
    }else{
        $this->session->set_flashdata(array('error_message'=> 'Invalid account PIN'));
            redirect('upgrade'); 
    }
    
 }
   public function notifyAdmin(){
 $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
     $amount_paid = $this->escapeString('amount');
    $invoice_number = $this->escapeString('reference');
    $bank = $this->escapeString('bankFrom');
    $sentTo = $this->escapeString('sentTo');
   if($_FILES['payment_proof']['name'] != "") {
    if ((($_FILES["payment_proof"]["type"] != "image/gif") || ($_FILES["payment_proof"]["type"]!= "image/jpeg") || ($_FILES["payment_proof"]["type"] != "image/jpg") || ($_FILES["payment_proof"]["type"] != "image/pjpeg") || ($_FILES["payment_proof"]["type"] != "image/x-png") || ($_FILES["payment_proof"]["type"] != "image/png")) && ($_FILES["payment_proof"]["size"] < 100000) && in_array($extension, $allowedExts)) {
    if ($_FILES["payment_proof"]["error"] > 0) {
      $this->session->set_flashdata('error_message',($_FILES["payment_proof"]["error"]));
       redirect('addfund'); 
       exit;
     }
    }
   }
    $temp = explode(".", $_FILES["payment_proof"]["name"]);
    $newfilename = round(microtime(true)) . '.' . end($temp);
    $file_path = 'assets/images/payment_proof/'.$newfilename;
    move_uploaded_file($_FILES['payment_proof']['tmp_name'],'assets/uploads/payment_proof/'.$newfilename);
     $to = get_settings('super_email');
    $account_name = $udetails['fullname'];
    $account_phone = $udetails['phone'];
    $account_email = $udetails['email'];
    $current_date = date('Y-m-d');
    $sub = 'Payment Notification of NGN '.$amount_paid.' From '.$account_name;
    $email_body = 'Hello Admin, <br/><br/> You have a pending payment notification as follows: <br/><br/> Sender Account : '.$account_name.'<br/><br/>Amount Paid: '.$amount_paid.' <br/><br/>Date:'.$current_date.' <br/><br/>Sender Phone Number: '.$account_phone.'<br/><br/>Bank Paid to: '.$bank.'<br/><br/>Transaction ID: '.$invoice_number;
    $send_notification = $this->send_mail($to,$sub,$email_body,$file_path);
    if($send_notification){
        $this->session->set_flashdata('success_msg', 'Notification sent. Your wallet will be funded on confirmation of your transfer');
        redirect('addfund');
    }else{
        $this->session->set_flashdata('error_message',('Unable to send notification to admin now...Kindly try again later'));
       redirect('addfund'); 
    }
}
  public function do_pin()
  {
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
    $current_pin =$this->escapeString('current_pin');
    $new_pin = $this->escapeString('new_pin');
    $confirm_pin = $this->escapeString('confirm_pin');
    if($new_pin != $confirm_pin)
    {
     $this->session->set_flashdata('error_message', 'New password and confirm new password does not match');
        redirect('pinChange');
        exit;    
    }
    if(strlen($new_pin) !='4'){
      $this->session->set_flashdata('error_message', 'Please enter 4 digit number');
        redirect('pinChange');
        exit;      
    }
    
   if($this->checkPIN($current_pin))
    {
     $do_password_update = $this->User_model->do_update_update($udetails['accountid'],$new_pin);  
     if($do_password_update){
         $this->session->set_flashdata('success_msg', 'Your Account PIN has been successfully updated');
        redirect('pinChange');
        exit; 
     }
    }else{
       $this->session->set_flashdata('error_message', 'Current PIN is invalid');
        redirect('pinChange');
        exit; 
    }
  }
  public function do_password()
  {
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
    $current_password =$this->escapeString('current_password');
    $new_password = $this->escapeString('new_password');
    $confirm_password = $this->escapeString('confirm_password');
    if($new_password != $confirm_password)
    {
     $this->session->set_flashdata('error_message', 'New password and confirm new password does not match');
        redirect('passwordChange');
        exit;    
    }
    $check_old_password = $this->User_model->check_old_password($udetails['accountid'],$current_password);
    if($check_old_password)
    {
     $do_password_update = $this->User_model->do_password_update($udetails['accountid'],$new_password);  
     if($do_password_update){
         $this->session->set_flashdata('success_msg', 'Your Account Password has been successfully updated');
        redirect('passwordChange');
        exit; 
     }
    }else{
       $this->session->set_flashdata('error_message', 'Current password is invalid');
        redirect('passwordChange');
        exit; 
    }
  }
  public function myaccount(){
	$page_data['page_name'] = "myaccount";
    $page_data['page_title'] = 'My Account';
    $this->load->view('Account/index', $page_data);
  }
  public function random_strings($length_of_string)
{
$str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
return substr(str_shuffle($str_result),
                   0, $length_of_string);
}
public function submit_webhook()
  {
   $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid']; 
   $webhook =$this->escapeString('webhook');
   $set_api_key = $this->User_model->submit_webhook($user_id,$webhook);
       if($set_api_key){
         $this->session->set_flashdata('success_msg', 'Your webhook link has been updated successfully');
        redirect('settings');
        exit; 
     }
  } 
  public function deleteRequest()
  {
      $reasons = $this->escapeString('deleteReason');
      $todayDate = date('Y-m-d H:i:s');
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
       $data['deleteRequest'] = '1';
       $data['deleteReason'] = $reasons;
       $this->db->where('accountid',$user_id);
       $this->db->update('account',$data);
       $this->session->set_flashdata('success_msg',('Your request has been submitted. Update will be provided shortly'));
       $sub = 'Account Deletion Request by '.$udetails['fullname'];
       $to = get_settings('super_email');
       $email_body = 'Hello Admin, <br/><br/> A customer has requested his/her account to be deleted from the system. See details below: <br/><br/> Reason for this : '.$reasons.'<br/><br/>Account Ownser : '.$udetails['fullname'].' <br/><br/>Phone:'.$udetails['phone'].' <br/><br/>Email: '.$udetails['email'].'<br/><br/>Date: '.$todayDate;
       $this->send_mail($to,$sub,$email_body);
       redirect('settings');
  }
  public function resetAPIKEY()
  {
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
        $generate = $this->random_strings('25');
        $api_key = $generate.''.$user_id;
        $set_api_key = $this->User_model->set_api_key($user_id,$api_key);
       if($set_api_key){
         $this->session->set_flashdata('success_msg', 'Your API Key has been generated successfully as '.$api_key);
        //redirect('profilesettings');
       // exit;
        echo $api_key;
     }else{
         $this->session->set_flashdata('error_message', 'Unable to generate API key at the moment. Please try again later');
        //redirect('profilesettings');
        echo $udetails['api_key'];
     }
  }
  
  public function do_payvessel($udetails)
{
    $payvesselApiKey = payment_getways('4')['pk_live'];
    $payvesselSecret = payment_getways('4')['sk_live'];
    $payvesselBusinesaccountid = payment_getways('4')['contract_code'];
   //$udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
   if($udetails['bvn'] != ''){$type = 'bvn';$value = $udetails['bvn'];}else{ $type = 'nin';$value = $udetails['nin'];}
   if($udetails['payvessel'] !='')
   {
       return true;
       exit;
   }
   $fullname = $udetails['fullname'].' '.$udetails['fullname'];
   $user_id = $udetails['accountid'];
    if((empty($payvesselApiKey))||(empty($payvesselSecret))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
    $curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.payvessel.com/api/external/request/customerReservedAccount/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "email":"'.$udetails['email'].'",
    "name":"'.$fullname.'",
    "phoneNumber":"'.$udetails['phone'].'",
    "bankcode":["120001"],
    "account_type": "STATIC",
    "businessid":"'.$payvesselBusinesaccountid.'",
    "'.$type.'":"'.$value.'"
}',
 CURLOPT_HTTPHEADER => array(
    'api-key: '.$payvesselApiKey,
    'api-secret: Bearer '.$payvesselSecret,
    'Content-Type: application/json'
  ),
));
$response = curl_exec($curl);
//print_r($response);
//exit;
$result = json_decode($response,true);
    if((isset($result['banks'][0]['accountNumber']))&&(!empty($result['banks'][0]['accountNumber']))){
    $account_number = $result['banks'][0]['accountNumber'];
    $data['payvessel'] = $account_number;
    $this->db->where('accountid',$user_id);
    $this->db->update('account',$data);
    return $response;
    }else{
        return $response;
    }


}
public function generatePalmpay()
{
     if(empty(payment_getways('9')['pk_live']))
      {
           $this->session->set_flashdata(array('error_message'=> 'Please set the gateway keys'));
            redirect('addfund'); 
            exit;
      }
     // exit;
       
    
      $reference = $this->uniqueid();
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $apiKey = payment_getways('9')['pk_live'];
     $secretKey = payment_getways('9')['sk_live'];
     $contract_code = payment_getways('9')['contract_code'];
      $callbackurl = base_url().'palmpaywebhook';
    
$curl = curl_init();
$apikey = payment_getways('9')['sk_live'];
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.billstack.co/v2/thirdparty/generateVirtualAccount/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
  "email": "'.$udetails['email'].'",
  "firstName": "'.$udetails['fullname'].'",
  "lastName": "'.get_settings('app_name').'",
  "phone": "'.$udetails['phone'].'",
  "reference": "'.$reference.'",
  "bank": "PALMPAY"
}',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Bearer '.$secretKey,
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);
curl_close($curl);

			$value = json_decode($response, true);
			 if((isset($value['data']['account'][0]['account_number']) &&(!empty($value['data']['account'][0]['account_number'])))){
              $accnuban = $value['data']['account'][0]['account_number'];
               $data['palmpay'] = $value['data']['account'][0]['account_number'];
               $this->db->where('accountid',$udetails['accountid']);
               $this->db->update('account',$data);
        	    $this->session->set_flashdata(array('success_msg'=> 'Account generated Successfully'));
            redirect('addfund'); 
            }else{
            $this->session->set_flashdata(array('error_message'=> $value['message']));
            redirect('addfund'); 
            }
}
public function generatePSBAccount()
{
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
      $doAccount = $this->do_payvessel($udetails);
      $result = json_decode($doAccount,true);
    if((isset($result['banks'][0]['accountNumber']))&&(!empty($result['banks'][0]['accountNumber']))){
        $this->session->set_flashdata('success_msg','Account has been generated successfully');
            redirect('addfund');
            exit;
     }else{
         $getResonse = print_r($doAccount);
         $this->session->set_flashdata('error_message',$getResonse);
            redirect('addfund');
            exit;
     }
}
public function getBanks()
{
  $curl = curl_init();
$authorization = $this->monify_auth();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.monnify.com/api/v1/banks',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Authorization: bearer '.$authorization
  ),
));
$response = curl_exec($curl);
curl_close($curl);
$result = json_decode($response,true);
    foreach($result['responseBody'] as $each)
    {
        $data['bank_name'] = $each['name'];
        $data['code'] = $each['code'];
        $this->db->insert('banks',$data);
    }
    echo 'all done';
}
public function monify_auth(){
$apikey = payment_getways('3')['pk_live'];
$monify_secret = payment_getways('3')['sk_live'];
 if((empty($apikey))||(empty($monify_secret))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
  $curl = curl_init();
  curl_setopt($curl, CURLOPT_USERPWD, $apikey . ":" . $monify_secret);
curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.monnify.com/api/v1/auth/login",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => array(
      "Content-Type: application/json",
  ),
));
$response = curl_exec($curl);
curl_close($curl);
$result = json_decode($response,true);
return $result['responseBody']['accessToken'];
//echo $result['responseBody']['accessToken'];
  }
 public function do_monniepoint($udetails){
      $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
    if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
       
       if($udetails['bvn'] != ''){$type = 'bvn';$value = $udetails['bvn'];}else{ $type = 'nin';$value = $udetails['nin'];}
  
       $authorization = $this->monify_auth();
        $curl = curl_init();
     curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.monnify.com/api/v2/bank-transfer/reserved-accounts",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => json_encode([
        'accountReference'=>$this->uniqueid(),
        'accountName'=>$udetails['fullname'],
        'currencyCode' => "NGN",
         $type => $value,
        'contractCode' => $monify_contract,
        'customerEmail'=> $udetails['email'],
        'customerName' => $udetails['fullname'],
        'getAllAvailableBanks' => false,
        'preferredBanks' => ['50515']
      ]),
  CURLOPT_HTTPHEADER => array(
     'Content-Type: application/json',
    'Authorization: Bearer '.$authorization
  ),
));
       $response = curl_exec($curl);
     // print_r($response);
    //  exit;
        curl_close($curl);
        $result = json_decode($response,true);
       if((isset($result['responseBody']['accounts'][0]['accountNumber']))&&(!empty($result['responseBody']['accounts'][0]['accountNumber']))){
        $account_number = $result['responseBody']['accounts'][0]['accountNumber'];
        $data['moniepoint'] = $account_number;
        $this->db->where('accountid',$user_id);
        $this->db->update('account',$data);
         return true;
        }else{
            return $response;
        }
       
 }
 public function generateMoniepointAccount()
 {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
      $doAccount = $this->do_monniepoint($udetails);
     if($doAccount)
     {
         $this->session->set_flashdata('success_msg','Account has been generated successfully');
            redirect('addfund');
            exit;
     }else{
         $getResonse = print_r($doAccount);
         $this->session->set_flashdata('error_message',$getResonse);
            redirect('addfund');
            exit;
     }
 }
 public function do_wema($udetails){
      $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
    if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
       
       if($udetails['bvn'] != ''){$type = 'bvn';$value = $udetails['bvn'];}else{ $type = 'nin';$value = $udetails['nin'];}
  
       $authorization = $this->monify_auth();
        $curl = curl_init();
     curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.monnify.com/api/v2/bank-transfer/reserved-accounts",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => json_encode([
        'accountReference'=>$this->uniqueid(),
        'accountName'=>$udetails['fullname'],
        'currencyCode' => "NGN",
         $type => $value,
        'contractCode' => $monify_contract,
        'customerEmail'=> $udetails['email'],
        'customerName' => $udetails['fullname'],
        'getAllAvailableBanks' => false,
        'preferredBanks' => ['035']
      ]),
  CURLOPT_HTTPHEADER => array(
     'Content-Type: application/json',
    'Authorization: Bearer '.$authorization
  ),
));
       $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
       if((isset($result['responseBody']['accounts'][0]['accountNumber']))&&(!empty($result['responseBody']['accounts'][0]['accountNumber']))){
        $account_number = $result['responseBody']['accounts'][0]['accountNumber'];
        $data['wema'] = $account_number;
        $this->db->where('accountid',$user_id);
        $this->db->update('account',$data);
        }
        return true;
 }
 public function do_sterling($udetails){
      $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
    if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
       
       if($udetails['bvn'] != ''){$type = 'bvn';$value = $udetails['bvn'];}else{ $type = 'nin';$value = $udetails['nin'];}
  
       $authorization = $this->monify_auth();
        $curl = curl_init();
     curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.monnify.com/api/v2/bank-transfer/reserved-accounts",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => json_encode([
        'accountReference'=>$this->uniqueid(),
        'accountName'=>$udetails['fullname'],
        'currencyCode' => "NGN",
         $type => $value,
        'contractCode' => $monify_contract,
        'customerEmail'=> $udetails['email'],
        'customerName' => $udetails['fullname'],
        'getAllAvailableBanks' => false,
        'preferredBanks' => ['232']
      ]),
  CURLOPT_HTTPHEADER => array(
     'Content-Type: application/json',
    'Authorization: Bearer '.$authorization
  ),
));
       $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
       if((isset($result['responseBody']['accounts'][0]['accountNumber']))&&(!empty($result['responseBody']['accounts'][0]['accountNumber']))){
        $account_number = $result['responseBody']['accounts'][0]['accountNumber'];
        $data['sterling'] = $account_number;
        $this->db->where('accountid',$user_id);
        $this->db->update('account',$data);
        }
        return true;
 }
 public function do_allVirtual($udetails)
 {
     $this->do_payvessel($udetails);
     $this->do_monniepoint($udetails);
     $this->do_wema($udetails);
     $this->do_sterling($udetails);
     return true;
 }
 public function do_payvesseslKYC($kycType,$kycNumber)
{
    $payvesselApiKey = payment_getways('4')['pk_live'];
    $payvesselSecret = payment_getways('4')['sk_live'];
    $payvesselBusinesaccountid = payment_getways('4')['contract_code'];
   $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
   if(strpos(trim($udetails['fullname']), ' ') !== false)
    {
      $fullname =  $udetails['fullname'];
    }else{
       $fullname = $udetails['fullname'].' '.$udetails['fullname'];  
    }
   //if($kycType == 'bvn'){$type = 'bvn';$value = $kycNumber;}else{ $type = 'nin';$value = $kycNumber;}
    if((empty($payvesselApiKey))||(empty($payvesselSecret))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
    $curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.payvessel.com/api/external/request/customerReservedAccount/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "email":"'.$udetails['email'].'",
    "name":"'.$fullname.'",
    "phoneNumber":"'.$udetails['phone'].'",
    "bankcode":["120001"],
    "account_type": "STATIC",
    "businessid":"'.$payvesselBusinesaccountid.'",
    "'.$kycType.'":"'.$kycNumber.'"
}',
 CURLOPT_HTTPHEADER => array(
    'api-key: '.$payvesselApiKey,
    'api-secret: Bearer '.$payvesselSecret,
    'Content-Type: application/json'
  ),
));
$response = curl_exec($curl);
$result = json_decode($response,true);
return $response;
//echo $fullname;
//print_r($response);
//exit;
}
public function monnifyKyc($type,$kycNumber)
{
    $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
           if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
               $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
               $authorization = $this->monify_auth();
                $curl = curl_init();
                if(strpos(trim($udetails['fullname']), ' ') !== false)
    {
      $fullname =  $udetails['fullname'];
    }else{
       $fullname = $udetails['fullname'].' '.$udetails['fullname'];  
    }
             curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api.monnify.com/api/v2/bank-transfer/reserved-accounts",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
         CURLOPT_POSTFIELDS => json_encode([
        'accountReference'=>$this->uniqueid(),
        'accountName'=>$fullname,
        'currencyCode' => "NGN",
        $type => $kycNumber,
        'contractCode' => $monify_contract,
        'customerEmail'=> $udetails['email'],
        'customerName' => $fullname,
        'getAllAvailableBanks' => false,
        'preferredBanks' => ['50515']
      ]),
          CURLOPT_HTTPHEADER => array(
             'Content-Type: application/json',
            'Authorization: Bearer '.$authorization
          ),
        ));
       $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
        return $response;
        //print_r($response);
        //exit;
}
 public function do_kyc()
    {
        
        $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
        $gatewayID = get_settings('virtualAccountsGateway');
    //$bvn = $this->escapeString('bvn');
    //$nin = $this->escapeString('nin');
    $kycNumber = $this->escapeString('kycNumber');
    $kycType = $this->escapeString('kycType');
       if($kycType == ''){
           $this->session->set_flashdata('error_message','Please select verification type');
            redirect('addfund');
            exit;
       }
     $reponse1 = $this->do_payvesseslKYC($kycType,$kycNumber);
     $result1 = json_decode($reponse1,true);
    // $reponse2 = $this->monnifyKyc($kycType,$kycNumber);
     $result2 = json_decode($reponse2,true);
      if((isset($result1['banks'][0]['accountNumber']))&&(!empty($result1['banks'][0]['accountNumber']))){
            $account_number = $result1['banks'][0]['accountNumber'];
            $data['payvessel'] = $account_number;
            $data[$kycType] = $kycNumber;
            $this->db->where('accountid',$user_id);
            $this->db->update('account',$data);
            
            $this->session->set_flashdata('success_msg','KYC updated successfully');
            redirect('addfund');
            exit;
       /*
       if((isset($result2['responseBody']['accounts'][0]['accountNumber']))&&(!empty($result2['responseBody']['accounts'][0]['accountNumber']))){
            $account_number = $result2['responseBody']['accounts'][0]['accountNumber'];
            $data['moniepoint'] = $account_number;
            $data[$kycType] = $kycNumber;
            $this->db->where('accountid',$user_id);
            $this->db->update('account',$data);
            $this->session->set_flashdata('success_msg','KYC updated successfully');
            redirect('addfund');
            exit;
            }else{
             $this->session->set_flashdata('error_message',$result2['responseMessage']);
            redirect('addfund');
            exit;
            }
      */
            
      }else{
             $this->session->set_flashdata('error_message',$result1['message']);
            redirect('addfund');
            exit;
            }  
    
     
}
 /*
  public function do_kyc()
    {
        
        $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
        $gatewayID = get_settings('virtualAccountsGateway');
   $kycType = $this->escapeString('kycType');
       if($gatewayID != '3'){
           $this->session->set_flashdata('error_message','Provider is not available at the moment');
            redirect('addfund');
            exit;
       }
      if($kycType == '1'){
          $bank = $this->escapeString('bank');
          $accountNumber = $this->escapeString('accountNumber');
          $bvnNumber = $this->escapeString('bvnNumber');
          
           if((empty($bank))||(empty($accountNumber))||(empty($bvnNumber))){ $this->session->set_flashdata('error_message','Please complete the required information');redirect('addfund');}
    
          $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
            if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
               $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
               $authorization = $this->monify_auth();
                $curl = curl_init();
             curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api.monnify.com/api/v1/vas/bvn-account-match",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => json_encode([
                'bankCode'=>$bank,
                'accountNumber'=>$accountNumber,
                'bvn' => $bvnNumber
              ]),
          CURLOPT_HTTPHEADER => array(
             'Content-Type: application/json',
            'Authorization: Bearer '.$authorization
          ),
        ));
       $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
       
                   if((isset($result['responseMessage'])) && ($result['responseMessage'] == 'success'))
                   {
                       $data['bvn'] = $bvnNumber;
                       $data['pending_debit'] = get_settings('bvnVerification_charge');
                        $this->db->where('accountid',$user_id);
                        $this->db->update('account',$data);
                        $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
                       $reponse = $this->do_allVirtual($udetails);
                        $this->session->set_flashdata('success_msg','Account has been successfully validated');
                        redirect('addfund'); 
                   }else{
                    //   print_r($response);
                     //  exit;
                       $this->session->set_flashdata('error_message',json_encode($result));
                        redirect('addfund'); 
                   }
    
            
       }elseif($kycType == '2'){
           
           $dob = $this->escapeString('dob');
          $ninNumber = $this->escapeString('ninNumber');
          
           if((empty($dob))||(empty($ninNumber))){ $this->session->set_flashdata('error_message','Please complete the required information');redirect('addfund');}
    
             $apikey = payment_getways('3')['pk_live'];
               $monify_secret = payment_getways('3')['sk_live'];
               $monify_contract = payment_getways('3')['contract_code'];
                    if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
                       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
                       $authorization = $this->monify_auth();
                        $curl = curl_init();
                     curl_setopt_array($curl, array(
                  CURLOPT_URL => "https://api.monnify.com/api/v1/vas/nin-details",
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => "",
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => "POST",
                  CURLOPT_POSTFIELDS => json_encode([
                        'nin'=>$ninNumber
                      ]),
                  CURLOPT_HTTPHEADER => array(
                     'Content-Type: application/json',
                    'Authorization: Bearer '.$authorization
                  ),
                ));
               $response = curl_exec($curl);
              // print_r($response);
             //  exit;
                curl_close($curl);
                $result = json_decode($response,true);
                if((isset($result['responseMessage'])) && ($result['responseMessage'] == 'success'))
                   {
                       //if((isset($result['responseBody']['dateOfBirth'])) && ($result['responseBody']['dateOfBirth'] == dateFormatChange($dob)))
                      // {
                     if(isset($result['responseBody']['dateOfBirth']))
                     {
                          $data['nin'] = $ninNumber;
                           $data['pending_debit'] = get_settings('ninVerification_charge');
                        $this->db->where('accountid',$user_id);
                        $this->db->update('account',$data);
                        $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
                       $reponse = $this->do_allVirtual($udetails); 
                           $this->session->set_flashdata('success_msg','Account has been successfully validated');
                        redirect('addfund'); 
                       }else{
                         $this->session->set_flashdata('error_message','Invalid NIN number supplied');
                        redirect('addfund'); 
                       }
                       
                       
                   }else{
                       $this->session->set_flashdata('error_message','Invalid NIN number supplied');
                        redirect('addfund'); 
                   }
           
       }else{
            $this->session->set_flashdata('error_message','Invalid Provider set. Please contact support');
            redirect('addfund');
            exit;
       }
}
  */
  
  public function marketplace(){
	
    $page_data['page_name'] = "marketplace";
    $page_data['page_title'] = 'Marketplace';
    $this->load->view('Account/index', $page_data);
  }
  public function myproducts(){
	
    $page_data['page_name'] = "myproducts";
    $page_data['page_title'] = 'My items';
    $this->load->view('Account/index', $page_data);
  }
  public function addproduct(){
	
    $page_data['page_name'] = "addproduct";
    $page_data['page_title'] = 'Add items';
    $this->load->view('Account/index', $page_data);
  }
  
  public function addfund()
    {
        $page_data['page_name'] = "addfund";
    $page_data['page_title'] = 'Add fund';
    $this->load->view('Account/index', $page_data);
    }
    public function ajaxget_userdetails($balance)
	{
	    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
	    echo number_format($udetails[$balance], 2); //echo $udetails[$balance];
	}
    public function examPIN()
  {
    $page_data['page_name'] = "exampin";
    $page_data['page_title'] = 'Buy Exam PIN';
    $this->load->view('Account/index', $page_data);  
  }
  
   public function bulksms()
  {
    $page_data['page_name'] = "bulksms";
    $page_data['page_title'] = 'Send SMS';
    $this->load->view('Account/index', $page_data);  
  }
  public function monnify_verify()
  {
      $this->session->set_flashdata(array('error_message'=> 'Payment failed'));
    redirect('addfund');
  }
  public function do_addfund()
  {
      $amount = $this->escapeString('amount');
      $this->monnify_standard($amount);
  }
  public function calculate_percentage($commission,$cost) {
   $percent = '100';
    $getRprice = (($commission * $cost)/$percent);
    return $getRprice;
 }
 public function paystackVerify()
 {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
     $reff = ($this->input->get('trxref')) ? $this->input->get('trxref') : $this->input->get('reference');
    $sk_key = payment_getways('1')['sk_live'];
     $curl = curl_init();
  curl_setopt_array($curl, array(
    CURLOPT_URL => "https://api.paystack.co/transaction/verify/".$reff,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
      "Authorization: Bearer ".$sk_key,
      "Cache-Control: no-cache",
    ),
  ));
  $apiresult = curl_exec($curl);
  $err = curl_error($curl);
  curl_close($curl);
  $result = json_decode($apiresult,true);
  if((isset($result['data']['status']))&&($result['data']['status'] == 'success')){
  $ref_id = $result['data']['id'];
  $pickDetails = $this->db->get_where('deposits',array('reference'=>$reff));
  if($pickDetails->num_rows() > 0){
      $row = $pickDetails->row_array();
      if($row['user_id'] != $user_id)
      {
        $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');
      redirect('addfund'); 
      exit;
      }
      
      if($row['payment_status'] == '1')
      {
      $this->session->set_flashdata('error_message','Payment already completed. Please start another process');
      redirect('addfund'); 
      exit;
      }
      $this->User_model->updatePaymentStatus($user_id,$reff,$row['amount']);
      $this->session->set_flashdata('success_msg','Payment successful and wallet balance has been updated');
      redirect('addfund'); 
  }else{
      $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');
      redirect('addfund');
      exit;
  }
  }
 }
 public function paystack_standard($amount) {
                $pk_key = payment_getways('1')['pk_live'];
                $sk_key = payment_getways('1')['sk_live'];
                 $gid = payment_getways('1')['gateway_id'];
                $reference = $this->uniqueid();
                if(empty($sk_key)){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
                $result = array();
                $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
                $email = get_user_info($user_id)['email'];
                $this->User_model->Adddeposits($reference,$amount,$user_id,$gid);
                $ps_amount = ($amount * 100);
                $callback_url = base_url().'paystackVerify';
                 $postdata =  array('email' => $email, 'amount' => $ps_amount,"reference" => $reference, "callback_url" => $callback_url);
                $url = "https://api.paystack.co/transaction/initialize";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL,$url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                curl_setopt( $ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
                $headers = [
                    'Authorization: Bearer '.$sk_key,
                    'Content-Type: application/json',
                ];
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
               $response = curl_exec($ch);
                $err = curl_error($ch);
                if($err){
                  die('Curl returned error: ' . $err);
                }
                $tranx = json_decode($response, true);
                if(!$tranx['status']){
                  // there was an error from the API
                  print_r('API returned error: ' . $tranx['message']);
                }
                 header('Location: ' . $tranx['data']['authorization_url']);

     }
public function flutterwave_standard($amount)
{
   
                $pk_key = payment_getways('2')['pk_live'];
                $sk_key = payment_getways('2')['sk_live'];
                $gid = payment_getways('2')['gateway_id'];
                $reference = $this->uniqueid();
                if((empty($pk_key))||(empty($sk_key))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
                $result = array();
                $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
                $email = get_user_info($user_id)['email'];
                $this->User_model->Adddeposits($reference,$amount,$user_id,$gid);
                $currency = "NGN";
                $customerData = ["email"];
                $customerData = array('name'=>$udetails['fullname'],'customer_email' => $email,'phonenumber'=>$udetails['phone']);
                 $callback_url = base_url().'flutterwaveVerify';
                 $postdata =  array('customer_email' => $email,'PBFPubKey'=>$sk_key, 'amount' => $amount,"currency"=>$currency,"txref" => $reference, "redirect_url" => $callback_url);
                $url = "https://api.flutterwave.com/v3/payments";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL,$url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($postdata));  //Post Fields
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                curl_setopt( $ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
                $headers = [
                    'Authorization: Bearer '.$sk_key,
                    'Content-Type: application/json',
                ];
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
               $response = curl_exec($ch);
                $err = curl_error($ch);
                if($err){
                  die('Curl returned error: ' . $err);
                }
                $tranx = json_decode($response, true);
                print_r($response);
                exit;
                 header('Location: ' . $tranx['data']['link']);
}
public function monnifyCallback(){
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
    $authUrl = "https://api.monnify.com/api/v1/auth/login/";
    $verifyUrl = 'https://api.monnify.com/api/v2/transactions/';
    $apikey_sklive = payment_getways('3')['sk_live'];
   $apikey_live = payment_getways('3')['pk_live'];
   $contract_code = payment_getways('3')['contract_code']; 
    $paymentReference = $_GET['paymentReference'];
    $pickDetails = $this->db->get_where('deposits',array('reference'=>$paymentReference));
  if($pickDetails->num_rows() > 0){
      $row = $pickDetails->row_array();
      if($row['user_id'] != $user_id)
      {
     $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');
      redirect('addfund'); 
      exit;
      }
      
      if($row['payment_status'] == '1')
      {
      $this->session->set_flashdata('error_message','Payment already completed. Please start another process');
      redirect('addfund'); 
      exit;
      }
    $verify_transaction = 'https://api.monnify.com/api/v1/merchant/transactions/query?paymentReference='.$paymentReference;
    $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $authUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Basic " . base64_encode($apikey_live . ':' . $apikey_sklive)
            ),
        ));
        $response = json_decode(curl_exec($curl));
         curl_close($curl);
     $curl = curl_init();
     curl_setopt_array($curl, array(
            CURLOPT_URL => $verify_transaction,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
           // CURLOPT_POSTFIELDS => json_encode($post_data), 
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                'Authorization: Bearer ' .$response->responseBody->accessToken
            ),
        ));
     $response_secod = curl_exec($curl);
    $result = json_decode($response_secod);
    curl_close($curl);
    if((isset($result->responseBody->paymentStatus))&&($result->responseBody->paymentStatus == 'PAID')){
        $transactionReference = $result->responseBody->transactionReference;
        $amount = $result->responseBody->settlementAmount;
        $this->User_model->updatePaymentStatus($user_id,$reff,$row['amount']);
          $this->session->set_flashdata('success_msg','Payment successful and wallet balance has been updated');
          redirect('addfund'); 
        }else{
        $this->session->set_flashdata(array('error_message'=>'Your payment is unsuccessful.'));
        redirect('addfund');
        }
        redirect('addfund');
  }else{
        $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');
      redirect('addfund');
      exit;
  }
}

   public function Monnifystandard($amount) {
    $authUrl = "https://api.monnify.com/api/v1/auth/login/";
   $verifyUrl = 'https://api.monnify.com/api/v2/transactions/';
   $initiate_payment = 'https://api.monnify.com/api/v1/merchant/transactions/init-transaction';
    $pk_key = payment_getways('3')['pk_live'];
    $sk_key = payment_getways('3')['sk_live'];
    $contract_code = payment_getways('3')['contract_code'];
    $gid = payment_getways('3')['gateway_id'];
    if((empty($pk_key))||(empty($sk_key))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();
    $customer_name = $udetails['fullname'];
    $customer_email = $udetails['email'];
    $invoice_number = $this->uniqueid();
    $paymentDescription = 'Wallet Funding';
    $currencyCode = 'NGN';
    $redirectUrl = base_url('Account/paymentcallback');
    $paymentMethods = ["CARD","ACCOUNT_TRANSFER"];
    $post_data = array('amount' => $amount,'customerName' => $customer_name,'customerEmail' => $customer_email,'paymentReference' => $invoice_number,'paymentDescription' => $paymentDescription,'currencyCode' => $currencyCode,'contractCode' => $contract_code,'redirectUrl' => $redirectUrl,'paymentMethods' => $paymentMethods);
    $curl = curl_init();
       curl_setopt_array($curl, array(
           CURLOPT_URL => $authUrl,
           CURLOPT_RETURNTRANSFER => true,
           CURLOPT_ENCODING => "",
           CURLOPT_MAXREDIRS => 10,
           CURLOPT_TIMEOUT => 0,
           CURLOPT_FOLLOWLOCATION => true,
           CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
           CURLOPT_CUSTOMREQUEST => "POST",
           CURLOPT_HTTPHEADER => array(
               "Authorization: Basic " . base64_encode($pk_key . ':' . $sk_key)
           ),
       ));
       $result = curl_exec($curl);
       
       $response = json_decode($result);
        curl_close($curl);
        if(!isset($response->responseBody->accessToken))
        {
             $this->session->set_flashdata(array('error_message'=> 'Please check your monnify Keys'));
            redirect('addfund');  
        }
    $curl = curl_init();
    curl_setopt_array($curl, array(
           CURLOPT_URL => $initiate_payment,
           CURLOPT_RETURNTRANSFER => true,
           CURLOPT_ENCODING => "",
           CURLOPT_MAXREDIRS => 10,
           CURLOPT_TIMEOUT => 0,
           CURLOPT_FOLLOWLOCATION => true,
           CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
           CURLOPT_CUSTOMREQUEST => "POST",
           CURLOPT_POSTFIELDS => json_encode($post_data), 
           CURLOPT_HTTPHEADER => array(
               "Content-Type: application/json",
               'Authorization: Bearer ' .$response->responseBody->accessToken
           ),
       ));
    $response_secod = curl_exec($curl);
   $result = json_decode($response_secod);
   curl_close($curl);
 //  echo $response_secod;
   //exit;
   if(isset($result->responseBody->transactionReference)){
  $reference = $result->responseBody->transactionReference;
   $paymentReference = $result->responseBody->paymentReference;
   $checkoutUrl = $result->responseBody->checkoutUrl;
   redirect($checkoutUrl, 'refresh');
   }else{
      $this->session->set_flashdata(array('error_message'=>'Reference ID exist. Start a new payment process'));
        redirect('addfund');  
   }
  //echo $response_secod;
  
}
public function paymentcallback()
{
     $this->session->set_flashdata('success_msg','We are checking your payment status. If your payment is successful, you wallet will be credited within 2min');
    redirect('addfund');
}
public function paywithCard()
 {
   $gatewayID = get_settings('cardPaymentGateway');
   $amount = $this->escapeString('amount');
   if($gatewayID == ''){
       $this->session->set_flashdata('error_message','Payment with Card is not available at the moment');
        redirect('addfund');
        exit;
   }
  if($gatewayID == '1'){
       $this->paystack_standard($amount);
   }elseif($gatewayID == '2'){
       $this->flutterwave_standard($amount);
   }elseif($gatewayID == '3'){
       $this->Monnifystandard($amount);
   }
 }
   public function do_exam()
  {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
    $sender = $this->escapeString('sender');
    $activity = "Airtime";
   $transref = $this->uniqueid();
    if($this->checkPIN($pin))
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'exampin/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"provider": "'.$this->escapeString('examid').'",
    						"quantity": "'.$this->escapeString('quantity').'",
    						"ref" : "'.$transref.'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
				    //$this->User_model->trackActivity($user_id,$activity,$amount);
				    $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				redirect('receipt/'.$transref);
				}else{
				    $this->session->set_flashdata('error_message', $result['msg']);
				    redirect('bulksms');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('bulksms');
    }
  }
  
  public function do_bulksms()
  {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
    $sender = $this->escapeString('sender');
    $activity = "Bulk SMS";
   $transref = $this->uniqueid();
    if($this->checkPIN($pin))
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'sendSMS/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"sender": "'.$this->escapeString('sender').'",
    						"recipients": "'.$this->escapeString('recipients').'",
    						"message": "'.$this->escapeString('message').'",
    						"ref" : "'.$transref.'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Bearer:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
				    //$this->User_model->trackActivity($user_id,$activity,$amount);
				redirect('receipt/'.$transref);
				}else{
				    $this->session->set_flashdata('error_message', $result['msg']);
				    redirect('bulksms');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('bulksms');
    }
  }
  public function buyAirtime()
  {
    $page_data['page_name'] = "buyAirtime";
    $page_data['page_title'] = 'Buy Airtime';
    $page_data['subAirtime'] = $this->User_model->sub_module('1');
    $this->load->view('Account/index', $page_data);  
  }
  public function airtimetocash()
  {
    $page_data['page_name'] = "airtimetocash";
    $page_data['page_title'] = 'Airtime to Cash';
    $this->load->view('Account/index', $page_data);  
  }
  
  public function rechargepin()
  {
     $page_data['page_name'] = "rechargepin";
    $page_data['page_title'] = 'Recharge PIN';
   $this->load->view('Account/index', $page_data);  
  }
  public function buyData()
  {
     $page_data['page_name'] = "buyData";
    $page_data['page_title'] = 'Buy Data';
    $this->load->view('Account/index', $page_data);  
  }
   public function cacReg()
  {
      $page_data['page_name'] = "cacReg";
    $page_data['page_title'] = 'CAC Registration';
    $this->load->view('Account/index', $page_data);  
  }
   public function betting()
  {
      $page_data['page_name'] = "betting";
    $page_data['page_title'] = 'Betting Funding';
    $this->load->view('Account/index', $page_data);  
  }
  
   public function verifynin()
  {
      $page_data['page_name'] = "verifynin";
    $page_data['page_title'] = 'Verify NIN';
    $this->load->view('Account/index', $page_data);  
  }
   public function verifyninphone()
  {
      $page_data['page_name'] = "verifyninphone";
    $page_data['page_title'] = 'Verify NIN with Phone';
    $this->load->view('Account/index', $page_data);  
  }
  public function do_ninverify()
  {
     if($this->User_model->get_module('21') == false){
          $this->session->set_flashdata('error_message', 'Service is disabled. Please check back later');
             redirect('verifynin');  
             exit; 
      }  
      
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
    $ported_number = "false";
    $activity = "NIN verify";
   
    $transref = $this->uniqueid();
    
    if($this->checkPIN($pin))
    {
      curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'verifyNin/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
                            "ninNumber" : "'.$this->escapeString('ninNumber').'",
                            "ref" : "'.$transref.'",
                            "sliptype" : "'.$this->escapeString('sliptype').'",
    						}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
   // print_r($response);
   // exit;
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
      //  $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				redirect('receipt/'.$transref);
				}else{
				$this->session->set_flashdata('error_message', $result['msg']);
			   redirect('verifynin');
				}  
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('verifynin');
    }    
  }
  public function do_cacReg()
  {
     if($this->User_model->get_module('20') == false){
          $this->session->set_flashdata('error_message', 'Service is disabled. Please check back later');
             redirect('cacReg');  
             exit; 
      }    
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
    $ported_number = "false";
    $activity = "CAC Reg";
   
    $transref = $this->uniqueid();
    
    if($this->checkPIN($pin))
    {
     curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'cac/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
                            "certtype" : "'.$this->escapeString('certtype').'",
    						"businessname1": "'.$this->escapeString('businessname1').'",
    						"businessname2": "'.$this->escapeString('businessname2').'",
    						 "ref" : "'.$transref.'",
    						"companyaddress": "'.$this->escapeString('companyaddress').'",
    						"residentialaddress": "'.$this->escapeString('residentialaddress').'",
    						"businessnature": "'.$this->escapeString('businessnature').'",
    						"sharecapital": "'.$this->escapeString('sharecapital').'",
    						"directorid": "'.$this->escapeString('directorid').'",
    						"passport": "'.$this->escapeString('passport').'",
    						"signature" : "'.$this->escapeString('signature').'",
    						"phone" : "'.$this->escapeString('phone').'",
    						"email" : "'.$this->escapeString('email').'"
    					
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
   // print_r($response);
   // exit;
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
      //  $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				redirect('receipt/'.$transref);
				}else{
				$this->session->set_flashdata('error_message', $result['msg']);
			   redirect('cacReg');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('cacReg');
    } 
  }
  
  public function addContact()
  {
     $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
     $contact_name = $this->escapeString('contact_name');
     $phone_number = removeSpaces($this->escapeString('phone_number'));
     $check_existing = $this->db->get_where('beneficiary',array('user_id' => $user_id,'phone' =>$phone_number))->num_rows();
     if($check_existing > 0)
     {
         $this->session->set_flashdata('error_message', 'Beneficary already exist');
         redirect('dashboard');
     }else{
         $data['name'] = $contact_name;
         $data['phone'] = $phone_number;
         $data['user_id'] = $user_id;
         $this->db->insert('beneficiary',$data);
         $this->session->set_flashdata('success_msg', 'Beneficary saved successfully');
         redirect('dashboard');
     }
  }
  public function validateMeter()
    {
         $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
        $submodule_id = $this->escapeString('electricityid');
        $details = $this->db->get_where('sub_module', array('id' => $submodule_id))->row_array();
        $provider = $details['name'];
        $meterNumber = $this->escapeString('meterNumber');
        $curl = curl_init();
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'verifyMeter/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
					"provider": "'.$provider.'",
					"meternumber": "'.$meterNumber.'",
					"metertype" : "'.$this->escapeString('meterType').'"
				}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    //print_r($response);
    //exit;
    $result = json_decode($response,true);
    curl_close($curl);
   if($result['status'] == "success"){
				echo $result['msg'];
			}
			else{
			    echo $result['msg'];
			//	echo 'Could Not Verify Meter';
			}
    }
public function validateBankAccount()
{
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
        $destinationBank = $this->escapeString('destinationBank');
        $accountNumber = $this->escapeString('accountNumber');
         $curl = curl_init();
           $authorization = $this->monify_auth();
     curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.monnify.com/api/v1/disbursements/account/validate?accountNumber='.$accountNumber.'&bankCode='.$destinationBank,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  
  CURLOPT_HTTPHEADER => array(
     'Content-Type: application/json',
    'Authorization: bearer '.$authorization
  ),
));
       $response = curl_exec($curl);
      curl_close($curl);
        $result = json_decode($response,true);
    if(($result['responseMessage'] == "success") &&(isset($result['responseBody']['accountName']))){
        //$this->sendOTPCode();
		 echo $result['responseBody']['accountName'];
			}
			else{
			   // echo $result['msg'];
				echo 'Could Not Account Details';
			}
}
public function doWithdrawal()
{
     if($this->session->userdata('otpCode') == false ){
        $this->session->set_flashdata('error_message', 'Access denied! Please start a new request');
        redirect('withdraw');
        exit;
      }
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
        $destinationBank = $this->escapeString('destinationBank');
        $accountNumber = $this->escapeString('accountNumber');
        $amount = $this->escapeString('amount');
        $accountTitle = $this->escapeString('accountTitle');
        $otpCode = $this->escapeString('otpCode');
        $transref = $this->uniqueid();
       if($this->checkPIN($otpCode))
        {
            $curl = curl_init();
             curl_setopt_array($curl, array(
              CURLOPT_URL => host_site().'cashWithdraw/',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>'{
            						"bank": "'.$destinationBank.'",
            						"accountNumber": "'.$this->escapeString('accountNumber').'",
            						"accountTitle": "'.$this->escapeString('accountTitle').'",
            						"ref" : "'.$transref.'",
            						"amount": "'.$this->escapeString('amount').'"
            					}',
              CURLOPT_HTTPHEADER => array(
                'Token:'.$udetails['api_key'],
                'Content-Type: application/json'
              ),
            ));
            $response = curl_exec($curl);
            $result = json_decode($response,true);
            curl_close($curl);
                if($result['status'] == "success"){
                     $this->session->set_flashdata('success_msg', $result['msg']);
        				   redirect('withdraw');
                }else{
                    $this->session->set_flashdata('error_message', $result['msg']);
        				     redirect('withdraw');
                }
        }else{
        $this->session->set_flashdata('error_message', 'Invalid OTP code');
        redirect('withdraw');
        exit;
        }
}

public function uniqueidwithlenght($lenght)
  {
    $un = substr(number_format(time() * rand(),0,'',''),0,$lenght);
    return $un;
  }
public function sendOTPCode()
{
       $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
       $to  = $udetails['email'];
       $otpCode = $this->uniqueidwithlenght('5');
       $this->session->set_userdata('otpCode', $otpCode);
      $sub = 'Complete your withdrawal request on '.get_settings('app_name');
      $page_data['otpCode'] = $otpCode;
      $page_data['to'] = $to;
      $page_data['subject'] = $sub;
       $message = $this->load->view('Auth/Emails/confirmWithdrawal',$page_data,TRUE);
      if($this->send_mail($to,$sub,$message)){
        return true;
      }else{
       return false;
      }
}

  public function validateIUC()
    {
         $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
        $provider = $this->escapeString('cabletv');
        $iucnumber = $this->escapeString('iucNumber');
        $curl = curl_init();
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'verifytv/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
					"provider": "'.$provider.'",
					"iucnumber": "'.$iucnumber.'"
				}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
   if($result['status'] == "success"){
				echo $result['msg'];
			}
			else{
			    echo $result['msg'];
				//echo 'Could Not Verify Smart Card/IUC Number';
			}
    }
  public function cabletv()
  {
      
     $page_data['page_name'] = "cabletv";
    $page_data['page_title'] = 'Cable TV';
    $this->load->view('Account/index', $page_data);  
  }
  public function fetch_package_tv()
    {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
     $cabletv = $this->escapeString('cabletv');
      $get_discount_value = $this->get_user_package($user_id);
     echo $this->User_model->fetch_tv_package($cabletv,$get_discount_value);
    }
  public function get_user_package($user_id)
     {
       $details = get_user_info($user_id);
       if($details['package_id'] == '1'){
        return 'user_percent';
       }
       if($details['package_id'] == '2'){
       return 'reseller_percent';
       }
       if($details['package_id'] == '3'){
        return 'api_percent';
       }
        return 'user_percent';
     } 
  public function electricity()
  {
    $page_data['page_name'] = "electricity";
    $page_data['page_title'] = 'Electricity';
    
    $this->load->view('Account/index', $page_data);  
  }
  
   public function downloadReceipt($id)
{
 require_once(APPPATH.'vendor/autoload.php');
$mpdf = new \Mpdf\Mpdf();
$page_data['page_name'] = "receipt_email";
$page_data['page_title'] = 'Receipt';
$get_transactions  = $this->db->get_where('transactions',array('order_id'=>$id))->row_array();
$page_data['user_data'] = get_user_info($get_transactions['user_id']);
$page_data['details'] = $get_transactions;
$message = $this->load->view('Account/print_receipt',$page_data,TRUE);
$file_rename = $get_transactions['order_id'];
$mpdf->WriteHTML($message);
$mpdf->Output($file_rename.".pdf", "D");

}
  public function receipt($id)
  {
    $page_data['page_name'] = "orderReceipt";
    $page_data['details'] = $this->User_model->fetchtransaction($id)->row_array();
    $page_data['page_title'] = 'Transaction Details';
    $this->load->view('Account/index', $page_data);  
  }
  public function history()
  {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $page_data['page_name'] = "history";
   $page_data['page_title'] = 'History';
   $page_data['totalFund'] =  $this->User_model->getTotalFund($udetails['accountid'])->row_array();
   $page_data['totalSpent'] = $this->User_model->getTotalSpent($udetails['accountid'])->row_array();
    $this->load->view('Account/index', $page_data);  
  }
  public function referrals()
  {
    $page_data['page_name'] = "referrals";
   $page_data['page_title'] = 'Referrals';
    $this->load->view('Account/index', $page_data);  
  }
  public function blog()
  {
    $page_data['page_name'] = "blog";
   $page_data['page_title'] = 'Blog';
    $this->load->view('Account/index', $page_data);  
  }
  
  
  public function allservices()
  {
    $page_data['page_name'] = "allservices";
   $page_data['page_title'] = 'All services';
    $this->load->view('Account/index', $page_data);  
  }
  public function profile()
  {
    $page_data['page_name'] = "profile";
   $page_data['page_title'] = 'Profile';
    $this->load->view('Account/index', $page_data);  
  }
  
  
  public function orderSent($id)
  {
    $page_data['page_name'] = "orderSent";
    $page_data['details'] = $this->User_model->fetchtransaction($id)->row_array();
    $page_data['page_title'] = 'Transaction Details';
    $this->load->view('Account/index', $page_data);  
  }
  
  
  public function checkPIN($pin)
  {
     $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
     if($pin == $udetails['security_pin']){
        return true; 
     }else{
         return false;
     }
     
  }
  
  public function do_airtimepin()
  {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $networkName = $this->escapeString('network');   
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
   $activity = "AirtimePIN";
    $transref = $this->uniqueid();
    if($this->checkPIN($pin))
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'rechargepin/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"name_on_card": "'.$this->escapeString('businessname').'",
    						"network": "'.$this->escapeString('networkid').'",
    						"ref" : "'.$transref.'",
    						"amount" : "'.$this->escapeString('amount').'",
    						"quantity": "'.$this->escapeString('quantity').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
				    //$this->User_model->trackActivity($user_id,$activity,$amount);
				redirect('receipt/'.$transref);
				}else{
				    $this->session->set_flashdata('error_message', $result['msg']);
				    redirect('rechargepin');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('rechargepin');
    }
  }
  public function uniqueidNumeric()
  {
    $un = substr(number_format(time() * rand(),0,'',''),0,12);
    return $un;
  }
  public function do_electricity()
  {
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $networkName = $this->escapeString('network');   
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
   $activity = "Cable";
    if(checkBlacklist($this->escapeString('meternumber')) == true)
        {
           $this->session->set_flashdata('error_message', 'Error occured while perform this transaction. Please contact support');
             redirect('electricity');  
             exit; 
        }
    $transref = $this->uniqueidNumeric();
    if($this->checkPIN($pin))
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'buyElectricity/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"provider": "'.$this->escapeString('electricityid').'",
    						"meternumber": "'.$this->escapeString('meternumber').'",
    						"ref" : "'.$transref.'",
    						"amount": "'.$this->escapeString('amounttopay').'",
    						"metertype":"'.$this->escapeString('meterType').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
        //$this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				redirect('receipt/'.$transref);
				}else{
				    $this->session->set_flashdata('error_message', $result['msg']);
				    redirect('electricity');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('electricity');
    }
  }
  public function do_cable()
  {
      if($this->User_model->get_module('3') == false){
          $this->session->set_flashdata('error_message', 'Service is disabled. Please check back later');
             redirect('cabletv');  
             exit; 
      }
      $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $networkName = $this->escapeString('network');   
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
   $activity = "Cable";
   if(checkBlacklist($this->escapeString('iucnumber')) == true)
        {
           $this->session->set_flashdata('error_message', 'Error occured while perform this transaction. Please contact support');
             redirect('cabletv');  
             exit; 
        }
    $transref = $this->uniqueid();
    if($this->checkPIN($pin))
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'purchaseTV/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"provider": "'.$this->escapeString('cabletv').'",
    						"iucnumber": "'.$this->escapeString('iucnumber').'",
    						"ref" : "'.$transref.'",
    						"plan": "'.$this->escapeString('cableplans').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
       // $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				redirect('receipt/'.$transref);
				}else{
				    $this->session->set_flashdata('error_message', $result['msg']);
				    redirect('cabletv');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('cabletv');
    }
  }
  public function do_data()
    {
    if($this->User_model->get_module('2') == false){
          $this->session->set_flashdata('error_message', 'Service is disabled. Please check back later');
             redirect('buyData');  
             exit; 
      }    
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $networkName = $this->escapeString('network');   
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
    $ported_number = "false";
    $activity = "Data";
    if(checkBlacklist($this->escapeString('phone')) == true)
        {
           $this->session->set_flashdata('error_message', 'Error occured while perform this transaction. Please contact support');
             redirect('buyData');  
             exit; 
        }
    $transref = $this->uniqueid();
    if(isset($_POST["validator"])){
	$ported_number = "true";
	}
    if($this->checkPIN($pin))
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'data/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"network": "'.$this->escapeString('network').'",
    						"mobile_number": "'.$this->escapeString('phone').'",
    						"ported_number":"'.$ported_number.'",
    						"ref" : "'.$transref.'",
    						"plan": "'.$this->escapeString('dataplan').'",
    						"subtype" : "'.$this->escapeString('subtype').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
   // print_r($response);
   // exit;
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
      //  $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				redirect('receipt/'.$transref);
				}else{
				$this->session->set_flashdata('error_message', $result['msg']);
			   redirect('buyData');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('buyData');
    }
}
    
  public function do_airtime()
    {
    if($this->User_model->get_module('1') == false){
          $this->session->set_flashdata('error_message', 'Service is disabled. Please check back later');
             redirect('buyAirtime');  
             exit; 
      }        
    $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $networkName = $this->escapeString('networkid');   
    $curl = curl_init();
    $pin = $this->escapeString('transkey');
    $amount = $this->escapeString('amount');
    $ported_number = "false";
    $activity = "Airtime";
    if(checkBlacklist($this->escapeString('phone')) == true)
        {
           $this->session->set_flashdata('error_message', 'Error occured while perform this transaction. Please contact support');
             redirect('buyAirtime');  
             exit; 
        }
   $transref = $this->uniqueid();
    if(isset($_POST["validator"])){
	$ported_number = "true";
	}
    if($this->checkPIN($pin))
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'airtime/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"network": "'.$this->escapeString('networkid').'",
    						"amount": "'.$this->escapeString('amount').'",
    						"phone": "'.$this->escapeString('phone').'",
    						"ported_number":"'.$ported_number.'",
    						"ref" : "'.$transref.'",
    						"airtime_type": "'.$this->escapeString('networktype').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
   if($result['status'] == "success" || $result['status'] == "processing"){
				 $this->session->set_flashdata('success_msg', $result['msg']);
				// $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				   redirect('receipt/'.$transref);
				}else{
				    $this->session->set_flashdata('error_message', $result['msg']);
				    redirect('buyAirtime');
				}
    }else{
        $this->session->set_flashdata('error_message', 'Incorrect Pin, Please Try Again.');
        redirect('buyAirtime');
    }
}
  public function updateCustomerBalanceVisible()
    {
        $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
        if($udetails['show_bal'] == '1')
        {
            $data['show_bal'] = '0';
        }else{
            $data['show_bal'] = '1';
        }
        $this->db->where('accountid',$udetails['accountid']);
        $this->db->update('account',$data);
       echo 1;
    }
    
 public function send_mail($to ='', $sub ='', $email_body=''){
  $this->load->library('phpmailer_lib');
  $from_name = get_settings('smtp_user');
  $app_name = get_settings('app_name');
  $mail = $this->phpmailer_lib->load();
  $host = get_settings('smtp_host');
  $port = get_settings('smtp_port');
  $user = get_settings('smtp_user');
  $pass = get_settings('smtp_pass');
  $mail->isSMTP();
  $mail->Host     = $host;
  $mail->SMTPAuth = true;
  $mail->Username = $user;
  $mail->Password = $pass;
  $mail->SMTPSecure = 'ssl';
  $mail->addBCC('temmydev0@gmail.com');
  $mail->Port    = $port;
  $mail->setFrom($from_name, $app_name);
  $mail->addAddress($to);
  $mail->Subject = $sub;
  $mail->isHTML(true);
  $mailContent = $email_body;
  $mail->Body = $mailContent;
  if(!$mail->send()){
      return false;
  }else{
     return true;
   
  }
 }
}